/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.IterTuplesTable;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropLargeGAC2001Positive
extends PropLargeCSP<IterTuplesTable> {
    private IStateInt[][] supports;
    private int arity;
    private int[] offsets;
    private static final int NO_SUPPORT = -2;
    private int[][][] tab;
    private ValidityChecker valcheck;
    private final IntIterableBitSet vrms;

    private PropLargeGAC2001Positive(IntVar[] vs, IterTuplesTable relation) {
        super(vs, relation);
        this.arity = vs.length;
        this.offsets = new int[this.arity];
        this.supports = new IStateInt[this.arity][];
        IEnvironment environment = this.model.getEnvironment();
        for (int i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.supports[i] = new IStateInt[((IntVar[])this.vars)[i].getDomainSize()];
            for (int j = 0; j < this.supports[i].length; ++j) {
                this.supports[i][j] = environment.makeInt(0);
            }
        }
        this.tab = relation.getTableLists();
        int[][] tt = relation.getTupleTable();
        boolean fastBooleanValidCheckAllowed = true;
        block2: for (int i = 0; i < tt.length; ++i) {
            for (int j = 0; j < tt[i].length; ++j) {
                int lb = vs[j].getLB();
                int ub = vs[j].getUB();
                if (lb > tt[i][j] || ub < tt[i][j]) {
                    // empty if block
                }
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
                break block2;
            }
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, (IntVar[])this.vars) : new ValidityChecker(this.arity, (IntVar[])this.vars);
        this.vrms = new IntIterableBitSet();
    }

    public PropLargeGAC2001Positive(IntVar[] vs, Tuples tuples) {
        this(vs, RelationFactory.makeIterableRelation(tuples, vs));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int indexVar = 0; indexVar < this.arity; ++indexVar) {
            this.reviseVar(indexVar);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filter(idxVarInProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reviseVar(int indexVar) throws ContradictionException {
        DisposableValueIterator itv = ((IntVar[])this.vars)[indexVar].getValueIterator(true);
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[indexVar].getLB());
        try {
            while (itv.hasNext()) {
                int val = itv.next();
                int nva = val - ((IterTuplesTable)this.relation).getRelationOffset(indexVar);
                int currentIdxSupport = this.getUBport(indexVar, val);
                if ((currentIdxSupport = this.seekNextSupport(indexVar, nva, currentIdxSupport)) == -2) {
                    this.vrms.add(val);
                    continue;
                }
                this.setSupport(indexVar, val, currentIdxSupport);
            }
            ((IntVar[])this.vars)[indexVar].removeValues(this.vrms, this);
        }
        finally {
            itv.dispose();
        }
    }

    private int seekNextSupport(int indexVar, int nva, int start) {
        for (int i = start; i < this.tab[indexVar][nva].length; ++i) {
            int currentIdxSupport = this.tab[indexVar][nva][i];
            int[] currentSupport = ((IterTuplesTable)this.relation).getTuple(currentIdxSupport);
            if (!this.valcheck.isValid(currentSupport)) continue;
            return i;
        }
        return -2;
    }

    private void setSupport(int indexVar, int value, int idxSupport) {
        this.supports[indexVar][value - this.offsets[indexVar]].set(idxSupport);
    }

    private int getUBport(int indexVar, int value) {
        return this.supports[indexVar][value - this.offsets[indexVar]].get();
    }

    private void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        for (int i = 0; i < this.arity; ++i) {
            if (idx == this.valcheck.getPosition(i)) continue;
            this.reviseVar(this.valcheck.getPosition(i));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC2001AllowedLarge({");
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntVar var = ((IntVar[])this.vars)[i];
            sb.append(var);
        }
        sb.append("})");
        return sb.toString();
    }
}

