/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.LargeRelation;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropLargeGAC2001
extends PropLargeCSP<LargeRelation> {
    private IStateInt[] supports;
    private int[] blocks;
    private int size;
    private int[] offsets;
    private ValidityChecker valcheck;
    private final IntIterableBitSet vrms;

    private PropLargeGAC2001(IntVar[] vs, LargeRelation relation) {
        super(vs, relation);
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        boolean allboolean = true;
        for (int i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.blocks[i] = nbElt;
            if ((((IntVar[])this.vars)[i].getTypeAndKind() & 0x3F8) != 24) {
                allboolean = false;
            }
            if (!((IntVar[])this.vars)[i].hasEnumeratedDomain()) {
                throw new SolverException("GAC2001 can not be used with bound variables");
            }
            nbElt += ((IntVar[])this.vars)[i].getUB() - ((IntVar[])this.vars)[i].getLB() + 1;
        }
        this.supports = new IStateInt[nbElt * this.size];
        IEnvironment env = vs[0].getEnvironment();
        for (int i = 0; i < this.supports.length; ++i) {
            this.supports[i] = env.makeInt(Integer.MIN_VALUE);
        }
        this.valcheck = allboolean ? new FastBooleanValidityChecker(this.size, (IntVar[])this.vars) : new ValidityChecker(this.size, (IntVar[])this.vars);
        this.vrms = new IntIterableBitSet();
    }

    public PropLargeGAC2001(IntVar[] vs, Tuples tuples) {
        this(vs, RelationFactory.makeLargeRelation(tuples, vs));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int i;
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            for (i = 0; i < ((IntVar[])this.vars).length; ++i) {
                this.reviseVar(i, true);
            }
        }
        for (i = 0; i < this.size; ++i) {
            this.reviseVar(i, false);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.filter(idxVarInProp);
    }

    private void reviseVar(int indexVar, boolean fromScratch) throws ContradictionException {
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[indexVar].getLB());
        int val = ((IntVar[])this.vars)[indexVar].getLB();
        while (val <= ((IntVar[])this.vars)[indexVar].getUB()) {
            int[] currentSupport = this.seekNextSupport(indexVar, val, fromScratch);
            if (currentSupport != null) {
                this.setSupport(indexVar, val, currentSupport);
            } else {
                this.vrms.add(val);
            }
            val = ((IntVar[])this.vars)[indexVar].nextValue(val);
        }
        ((IntVar[])this.vars)[indexVar].removeValues(this.vrms, this);
    }

    private void setSupport(int indexVar, int value, int[] support) {
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].set(support[i]);
        }
    }

    private int[] getUBport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].get();
        }
        return resultat;
    }

    private int[] seekNextSupport(int indexVar, int val, boolean fromscratch) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        if (fromscratch) {
            for (int i = 0; i < this.size; ++i) {
                currentSupport[i] = i != indexVar ? ((IntVar[])this.vars)[i].getLB() : val;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        } else {
            currentSupport = this.getUBport(indexVar, val);
            if (this.valcheck.isValid(currentSupport)) {
                return currentSupport;
            }
            if ((currentSupport = this.getFirstValidTupleFrom(currentSupport, indexVar)) == null) {
                return null;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        }
        while (k < ((IntVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntVar[])this.vars).length) continue;
            if (((IntVar[])this.vars)[k].nextValue(currentSupport[k]) == Integer.MAX_VALUE) {
                currentSupport[k] = ((IntVar[])this.vars)[k].getLB();
                ++k;
                continue;
            }
            currentSupport[k] = ((IntVar[])this.vars)[k].nextValue(currentSupport[k]);
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }

    private int[] getFirstValidTupleFrom(int[] t, int indexVar) {
        int k = 0;
        while (k < ((IntVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntVar[])this.vars).length) continue;
            if (((IntVar[])this.vars)[k].nextValue(t[k]) == Integer.MAX_VALUE) {
                t[k] = ((IntVar[])this.vars)[k].getLB();
                ++k;
                continue;
            }
            t[k] = ((IntVar[])this.vars)[k].nextValue(t[k]);
            if (this.valcheck.isValid(t)) {
                return t;
            }
            k = 0;
        }
        return null;
    }

    private void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        if (((IntVar[])this.vars)[idx].hasEnumeratedDomain()) {
            for (int i = 0; i < this.size; ++i) {
                if (idx == this.valcheck.getPosition(i)) continue;
                this.reviseVar(this.valcheck.getPosition(i), false);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.reviseVar(this.valcheck.getPosition(i), false);
            }
        }
    }
}

