/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary.element;

import java.util.Iterator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropElement
extends Propagator<IntVar> {
    private final int[] values;
    private final int offset;
    private final IntVar index;
    private final IntVar result;
    private final IntIterableBitSet fidx;
    private final IntIterableBitSet pVals;

    public PropElement(IntVar value, int[] values, IntVar index, int offset) {
        super((Variable[])ArrayUtils.toArray(value, index), PropagatorPriority.BINARY, false);
        this.values = values;
        this.offset = offset;
        this.index = index;
        this.result = value;
        this.fidx = new IntIterableBitSet();
        this.fidx.setOffset(index.getLB());
        this.pVals = new IntIterableBitSet();
        this.pVals.setOffset(this.result.getLB());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.index.updateBounds(this.offset, this.values.length - 1 + this.offset, this);
        this.fidx.clear();
        this.pVals.clear();
        int iub = this.index.getUB();
        int i = this.index.getLB();
        while (i <= iub) {
            int value = this.values[i - this.offset];
            if (this.result.contains(value)) {
                this.pVals.add(value);
            } else {
                this.fidx.add(i);
            }
            i = this.index.nextValue(i);
        }
        this.result.removeAllValuesBut(this.pVals, this);
        if (!this.fidx.isEmpty()) {
            this.index.removeValues(this.fidx, this);
        }
        if (this.result.isInstantiated() && this.index.hasEnumeratedDomain() && !this.index.isInstantiated()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.index.getUB() < this.offset || this.index.getLB() >= this.offset + this.values.length) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(this.result.contains(this.values[this.index.getValue() - this.offset]));
        }
        if (this.result.isInstantiated()) {
            int val = this.result.getValue();
            boolean foundVal = false;
            boolean foundOther = false;
            Iterator iterator = this.index.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i >= this.offset && i < this.values.length + this.offset && this.values[i - this.offset] == val) {
                    foundVal = true;
                    if (!foundOther) continue;
                    break;
                }
                foundOther = true;
                if (!foundVal) continue;
                break;
            }
            if (foundVal) {
                if (foundOther) {
                    return ESat.UNDEFINED;
                }
                return ESat.TRUE;
            }
            return ESat.FALSE;
        }
        Iterator iterator = this.index.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i < this.offset || i >= this.values.length + this.offset || !this.result.contains(this.values[i - this.offset])) continue;
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder(32);
        sb.append("element(").append(this.result).append(" = ");
        sb.append(" <");
        for (i = 0; i < Math.min(this.values.length - 1, 5); ++i) {
            sb.append(this.values[i]).append(", ");
        }
        if (i == 5 && this.values.length - 1 > 5) {
            sb.append("..., ");
        }
        sb.append(this.values[this.values.length - 1]);
        sb.append("> [").append(this.index).append("])");
        return sb.toString();
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        return ruleStore.addPropagatorActivationRule(this) | ruleStore.addFullDomainRule(var == this.result ? this.index : this.result);
    }
}

