/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropNotEqualXY_C
extends Propagator<IntVar> {
    private IntVar x;
    private IntVar y;
    private int cste;

    public PropNotEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, PropagatorPriority.BINARY, false);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[vIdx].hasEnumeratedDomain()) {
            return IntEventType.instantiation();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.x.isInstantiated()) {
            if (this.y.removeValue(this.cste - this.x.getValue(), this) || !this.y.contains(this.cste - this.x.getValue())) {
                this.setPassive();
            }
        } else if (this.y.isInstantiated()) {
            if (this.x.removeValue(this.cste - this.y.getValue(), this) || !this.x.contains(this.cste - this.y.getValue())) {
                this.setPassive();
            }
        } else if (this.x.getLB() + this.y.getLB() > this.cste || this.x.getUB() + this.y.getUB() < this.cste) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste || this.y.getLB() + this.x.getLB() > this.cste) {
            return ESat.TRUE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() + this.y.getValue() == this.cste) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        newrules = var.equals(this.x) ? (newrules |= ruleStore.addFullDomainRule(this.y)) : (var.equals(this.y) ? (newrules |= ruleStore.addFullDomainRule(this.x)) : (newrules |= super.why(ruleStore, var, evt, value)));
        return newrules;
    }
}

