/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public final class PropGreaterOrEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;

    public PropGreaterOrEqualX_Y(IntVar[] vars) {
        super((Variable[])vars, PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.DECUPP);
        }
        return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.INCLOW);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(this.y.getLB(), this);
        this.y.updateUpperBound(this.x.getUB(), this);
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == 0) {
            this.y.updateUpperBound(this.x.getUB(), this);
        } else {
            this.x.updateLowerBound(this.y.getLB(), this);
        }
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB()) {
            return ESat.FALSE;
        }
        if (this.x.getLB() >= this.y.getUB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".GEQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        newrules = var.equals(this.x) ? (newrules |= ruleStore.addLowerBoundRule(this.y)) : (var.equals(this.y) ? (newrules |= ruleStore.addUpperBoundRule(this.x)) : (newrules |= super.why(ruleStore, var, evt, value)));
        return newrules;
    }
}

