/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public final class PropGreaterOrEqualXY_C
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private final int cste;

    public PropGreaterOrEqualXY_C(IntVar[] vars, int c) {
        super((Variable[])vars, PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
        this.cste = c;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.INSTANTIATE.getMask() + IntEventType.DECUPP.getMask();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(this.cste - this.y.getUB(), this);
        this.y.updateLowerBound(this.cste - this.x.getUB(), this);
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.y.updateLowerBound(this.cste - this.x.getUB(), this);
        } else {
            this.x.updateLowerBound(this.cste - this.y.getUB(), this);
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() + this.y.getUB() < this.cste) {
            return ESat.FALSE;
        }
        if (this.x.getLB() + this.y.getLB() >= this.cste) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.x.getName() + " + " + this.y.getName() + " >= " + this.cste;
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        newrules = var.equals(this.x) ? (newrules |= ruleStore.addUpperBoundRule(this.y)) : (var.equals(this.y) ? (newrules |= ruleStore.addUpperBoundRule(this.x)) : (newrules |= super.why(ruleStore, var, evt, value)));
        return newrules;
    }
}

