/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public final class PropEqualX_Y
extends Propagator<IntVar> {
    private IntVar x;
    private IntVar y;
    private boolean bothEnumerated;
    private IIntDeltaMonitor[] idms;
    private IntProcedure rem_proc;
    private int indexToFilter;

    public PropEqualX_Y(IntVar x, IntVar y) {
        super((Variable[])ArrayUtils.toArray(x, y), PropagatorPriority.BINARY, true);
        this.x = ((IntVar[])this.vars)[0];
        this.y = ((IntVar[])this.vars)[1];
        if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
            this.bothEnumerated = true;
            this.idms = new IIntDeltaMonitor[2];
            this.idms[0] = ((IntVar[])this.vars)[0].monitorDelta(this);
            this.idms[1] = ((IntVar[])this.vars)[1].monitorDelta(this);
            this.rem_proc = i -> ((IntVar[])this.vars)[this.indexToFilter].removeValue(i, this);
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain() && ((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    private void updateBounds() throws ContradictionException {
        while (this.x.updateLowerBound(this.y.getLB(), this) | this.y.updateLowerBound(this.x.getLB(), this)) {
        }
        while (this.x.updateUpperBound(this.y.getUB(), this) | this.y.updateUpperBound(this.x.getUB(), this)) {
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.updateBounds();
        if (this.bothEnumerated) {
            int ub = this.x.getUB();
            int val = this.x.getLB();
            while (val <= ub) {
                if (!this.y.contains(val)) {
                    this.x.removeValue(val, this);
                }
                val = this.x.nextValue(val);
            }
            ub = this.y.getUB();
            val = this.y.getLB();
            while (val <= ub) {
                if (!this.x.contains(val)) {
                    this.y.removeValue(val, this);
                }
                val = this.y.nextValue(val);
            }
            this.idms[0].unfreeze();
            this.idms[1].unfreeze();
        }
        if (this.x.isInstantiated()) {
            assert (this.y.isInstantiated());
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.updateBounds();
        if (this.x.isInstantiated()) {
            assert (this.y.isInstantiated());
            this.setPassive();
        } else if (this.bothEnumerated) {
            this.indexToFilter = 1 - varIdx;
            this.idms[varIdx].freeze();
            this.idms[varIdx].forEachRemVal(this.rem_proc);
            this.idms[varIdx].unfreeze();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB() || this.x.getLB() > this.y.getUB() || this.x.hasEnumeratedDomain() && this.y.hasEnumeratedDomain() && !this.match()) {
            return ESat.FALSE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() == this.y.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean match() {
        int lb = this.x.getLB();
        int ub = this.x.getUB();
        while (lb <= ub) {
            if (this.y.contains(lb)) {
                return true;
            }
            lb = this.x.nextValue(lb);
        }
        return false;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".EQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        if (var.equals(this.x)) {
            IntEventType ievt = (IntEventType)evt;
            switch (ievt) {
                case REMOVE: {
                    newrules |= ruleStore.addRemovalRule(this.y, value);
                    break;
                }
                case DECUPP: {
                    newrules |= ruleStore.addUpperBoundRule(this.y);
                    break;
                }
                case INCLOW: {
                    newrules |= ruleStore.addLowerBoundRule(this.y);
                    break;
                }
                case INSTANTIATE: {
                    newrules |= ruleStore.addFullDomainRule(this.y);
                    break;
                }
            }
        } else if (var.equals(this.y)) {
            IntEventType ievt = (IntEventType)evt;
            switch (ievt) {
                case REMOVE: {
                    newrules |= ruleStore.addRemovalRule(this.x, value);
                    break;
                }
                case DECUPP: {
                    newrules |= ruleStore.addUpperBoundRule(this.x);
                    break;
                }
                case INCLOW: {
                    newrules |= ruleStore.addLowerBoundRule(this.x);
                    break;
                }
                case INSTANTIATE: {
                    newrules |= ruleStore.addFullDomainRule(this.x);
                    break;
                }
            }
        } else {
            newrules |= super.why(ruleStore, var, evt, value);
        }
        return newrules;
    }
}

