/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class PropAbsolute
extends Propagator<IntVar> {
    private IntVar X;
    private IntVar Y;
    private boolean bothEnumerated;

    public PropAbsolute(IntVar X, IntVar Y) {
        super((Variable[])ArrayUtils.toArray(X, Y), PropagatorPriority.BINARY, true);
        this.X = ((IntVar[])this.vars)[0];
        this.Y = ((IntVar[])this.vars)[1];
        this.bothEnumerated = X.hasEnumeratedDomain() && Y.hasEnumeratedDomain();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain() && ((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars)[0].getUB() < 0) {
            return ESat.FALSE;
        }
        if (((IntVar[])this.vars)[0].isInstantiated()) {
            if (((IntVar[])this.vars)[1].isInstantiated()) {
                return ESat.eval(((IntVar[])this.vars)[0].getValue() == Math.abs(((IntVar[])this.vars)[1].getValue()));
            }
            if (((IntVar[])this.vars)[1].getDomainSize() == 2 && ((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && ((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.TRUE;
            }
            if (!((IntVar[])this.vars)[1].contains(((IntVar[])this.vars)[0].getValue()) && !((IntVar[])this.vars)[1].contains(-((IntVar[])this.vars)[0].getValue())) {
                return ESat.FALSE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return String.format("%s = |%s|", ((IntVar[])this.vars)[0].toString(), ((IntVar[])this.vars)[1].toString());
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.X.updateLowerBound(0, this);
        this.setBounds();
        if (this.bothEnumerated) {
            this.enumeratedFiltering();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            if (varIdx == 1) {
                this.setPassive();
                this.X.instantiateTo(Math.abs(this.Y.getValue()), this);
            } else if (this.Y.hasEnumeratedDomain()) {
                this.setPassive();
                int val = this.X.getValue();
                this.Y.updateBounds(-val, val, this);
                this.Y.removeInterval(-(--val), val, this);
            } else {
                this.setBounds();
            }
        } else {
            if (IntEventType.isBound(mask)) {
                this.setBounds();
            }
            if (IntEventType.isRemove(mask) && this.bothEnumerated) {
                this.enumeratedFiltering();
            }
        }
    }

    private void setBounds() throws ContradictionException {
        int max = this.X.getUB();
        int min = this.X.getLB();
        this.Y.updateBounds(-max, max, this);
        this.Y.removeInterval(1 - min, min - 1, this);
        int prevLB = this.X.getLB();
        int prevUB = this.X.getUB();
        min = this.Y.getLB();
        max = this.Y.getUB();
        if (max <= 0) {
            this.X.updateBounds(-max, -min, this);
        } else if (min >= 0) {
            this.X.updateBounds(min, max, this);
        } else {
            if (this.Y.hasEnumeratedDomain()) {
                int mP = this.Y.nextValue(-1);
                int mN = -this.Y.previousValue(1);
                this.X.updateLowerBound(Math.min(mP, mN), this);
            }
            this.X.updateUpperBound(Math.max(-min, max), this);
        }
        if (prevLB != this.X.getLB() || prevUB != this.X.getUB()) {
            this.setBounds();
        }
    }

    private void enumeratedFiltering() throws ContradictionException {
        int min = this.X.getLB();
        int max = this.X.getUB();
        int v = min;
        while (v <= max) {
            if (!this.Y.contains(v) && !this.Y.contains(-v)) {
                this.X.removeValue(v, this);
            }
            v = this.X.nextValue(v);
        }
        min = this.Y.getLB();
        max = this.Y.getUB();
        v = min;
        while (v <= max) {
            if (!this.X.contains(Math.abs(v))) {
                this.Y.removeValue(v, this);
            }
            v = this.Y.nextValue(v);
        }
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        if (var.equals(((IntVar[])this.vars)[0])) {
            newrules |= ruleStore.addRemovalRule(((IntVar[])this.vars)[1], value);
            newrules |= ruleStore.addRemovalRule(((IntVar[])this.vars)[1], -value);
        } else {
            newrules = var.equals(((IntVar[])this.vars)[1]) ? (newrules |= ruleStore.addRemovalRule(((IntVar[])this.vars)[0], Math.abs(value))) : (newrules |= super.why(ruleStore, var, evt, value));
        }
        return newrules;
    }
}

