/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.reification.PropReif;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.ArrayUtils;

public class ReificationConstraint
extends Constraint {
    private final BoolVar bool;
    private final Constraint trueCons;
    private final Constraint falseCons;
    private int[] indices;
    private final PropReif propReif;

    protected ReificationConstraint(BoolVar bVar, Constraint consIfBoolTrue, Constraint consIfBoolFalse) {
        super("ReificationConstraint", ReificationConstraint.createProps(bVar, consIfBoolTrue, consIfBoolFalse));
        this.propReif = (PropReif)this.propagators[0];
        this.propReif.setReifCons(this);
        this.trueCons = consIfBoolTrue;
        this.falseCons = consIfBoolFalse;
        this.bool = bVar;
        this.indices = new int[3];
        this.indices[0] = 1;
        this.indices[1] = this.indices[0] + this.trueCons.getPropagators().length;
        this.indices[2] = this.indices[1] + this.falseCons.getPropagators().length;
        for (int i = 1; i < this.propagators.length; ++i) {
            this.propagators[i].setReifiedSilent();
        }
    }

    private static Propagator[] createProps(BoolVar bVar, Constraint trueCons, Constraint falseCons) {
        HashSet<Variable> setOfVars = new HashSet<Variable>();
        ReificationConstraint.prepareConstraint(bVar, trueCons, setOfVars);
        ReificationConstraint.prepareConstraint(bVar, falseCons, setOfVars);
        Variable[] allVars = ArrayUtils.append({bVar}, setOfVars.toArray(new Variable[setOfVars.size()]));
        PropReif reifProp = new PropReif(allVars, trueCons, falseCons);
        return ArrayUtils.append({reifProp}, (Propagator[])trueCons.getPropagators().clone(), (Propagator[])falseCons.getPropagators().clone());
    }

    private static void prepareConstraint(BoolVar bVar, Constraint c, Set<Variable> setOfVars) {
        for (Propagator p : c.getPropagators()) {
            for (Variable v : p.getVars()) {
                if (v == bVar) continue;
                setOfVars.add(v);
            }
        }
    }

    public void activate(int idx) throws ContradictionException {
        Model model = this.propagators[0].getModel();
        assert (this.bool.isInstantiatedTo(1 - idx));
        for (int p = this.indices[idx]; p < this.indices[idx + 1]; ++p) {
            assert (this.propagators[p].isReifiedAndSilent());
            this.propagators[p].setReifiedTrue();
            model.getSolver().getExplainer().activePropagator(this.bool, this.propagators[p]);
            this.propagators[p].propagate(PropagatorEventType.FULL_PROPAGATION.getMask());
            model.getSolver().getEngine().onPropagatorExecution(this.propagators[p]);
        }
    }

    @Override
    public ESat isSatisfied() {
        return this.propReif.isEntailed();
    }

    @Override
    public String toString() {
        return this.bool.toString() + "=>" + this.trueCons.toString() + ", !" + this.bool.toString() + "=>" + this.falseCons.toString();
    }
}

