/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.Arrays;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;

public abstract class Propagator<V extends Variable>
implements ICause,
Identity,
Comparable<Propagator> {
    private static final short NEW = 0;
    private static final short REIFIED = 1;
    private static final short ACTIVE = 2;
    private static final short PASSIVE = 3;
    private final int ID;
    private short state;
    private IOperation[] operations;
    private final boolean swapOnPassivate;
    protected final PropagatorPriority priority;
    protected final boolean reactToFineEvt;
    protected Constraint constraint;
    protected final Model model;
    protected V[] vars;
    private int[] vindices;

    protected Propagator(V[] vars, PropagatorPriority priority, boolean reactToFineEvt, boolean swapOnPassivate) {
        assert (vars != null && vars.length > 0 && vars[0] != null) : "wrong variable set in propagator constructor";
        this.model = vars[0].getModel();
        this.reactToFineEvt = reactToFineEvt;
        this.state = 0;
        this.priority = priority;
        this.vars = this.model.getSettings().cloneVariableArrayInPropagator() ? (Variable[])vars.clone() : vars;
        this.vindices = new int[vars.length];
        this.ID = this.model.nextId();
        this.swapOnPassivate = this.model.getSettings().swapOnPassivate() | swapOnPassivate;
        this.operations = new IOperation[3 + (this.swapOnPassivate ? vars.length : 0)];
        this.operations[0] = () -> {
            this.state = 0;
        };
        this.operations[1] = () -> {
            this.state = 1;
        };
        this.operations[2] = () -> {
            this.state = (short)2;
        };
    }

    protected Propagator(V[] vars, PropagatorPriority priority, boolean reactToFineEvt) {
        this((Variable[])vars, priority, reactToFineEvt, false);
    }

    @SafeVarargs
    protected Propagator(V ... vars) {
        this((Variable[])vars, PropagatorPriority.LINEAR, false);
    }

    @SafeVarargs
    protected final void addVariable(V ... nvars) {
        V[] tmp = this.vars;
        this.vars = (Variable[])Arrays.copyOf(this.vars, this.vars.length + nvars.length);
        System.arraycopy(nvars, 0, this.vars, tmp.length, nvars.length);
        int[] itmp = this.vindices;
        this.vindices = new int[this.vars.length];
        System.arraycopy(itmp, 0, this.vindices, 0, itmp.length);
        for (int v = tmp.length; v < this.vars.length; ++v) {
            this.vindices[v] = this.vars[v].link(this, v);
        }
        if (this.model.getSolver().getEngine() != NoPropagationEngine.SINGLETON && this.model.getSolver().getEngine().isInitialized()) {
            this.model.getSolver().getEngine().updateInvolvedVariables(this);
        }
    }

    public final void linkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vindices[v] = this.vars[v].link(this, v);
        }
    }

    public final void unlinkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vars[v].unlink(this, v);
        }
    }

    void defineIn(Constraint c) throws SolverException {
        if (this.constraint != null && this.constraint.getStatus() != Constraint.Status.FREE || c.getStatus() != Constraint.Status.FREE) {
            throw new SolverException("This propagator is already defined in a constraint. This happens when a constraint is reified and posted.");
        }
        this.constraint = c;
    }

    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    public abstract void propagate(int var1) throws ContradictionException;

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (this.reactToFineEvt) {
            throw new SolverException(this + " has been declared to ignore which variable is modified.\n" + "To change the configuration, consider:\n" + "- to set 'reactToFineEvt' to false or,\n" + "- to override the following method:\n" + "\t'public void propagate(int idxVarInProp, int mask) throws ContradictionException'." + "The latter enables incrementality but also to delay calls to complex filtering algorithm (see the method 'forcePropagate(EventType evt)'.");
        }
        this.propagate(PropagatorEventType.CUSTOM_PROPAGATION.getMask());
    }

    public final void forcePropagate(PropagatorEventType evt) throws ContradictionException {
        this.model.getSolver().getEngine().delayedPropagation(this, evt);
    }

    public void setActive() throws SolverException {
        if (!this.isStateLess()) {
            throw new SolverException("Try to activate a propagator already active, passive or reified.\n" + this + " of " + this.getConstraint());
        }
        this.state = (short)2;
        this.model.getEnvironment().save(this.operations[0]);
    }

    public void setReifiedTrue() throws SolverException {
        if (!this.isReifiedAndSilent()) {
            throw new SolverException("Reification process tries to force activation of a propagator already active or passive.\n" + this + " of " + this.getConstraint());
        }
        this.state = (short)2;
        this.model.getEnvironment().save(this.operations[1]);
    }

    public void setReifiedSilent() throws SolverException {
        if (!this.isStateLess() && !this.isReifiedAndSilent()) {
            throw new SolverException("Reification process try to reify a propagator already active or posted.\n" + this + " of " + this.getConstraint());
        }
        this.state = 1;
    }

    public void setPassive() throws SolverException {
        if (this.isActive()) {
            this.state = (short)3;
            this.model.getEnvironment().save(this.operations[2]);
            this.model.getSolver().getEngine().desactivatePropagator(this);
            if (this.swapOnPassivate) {
                int i;
                if (this.operations[3] == null) {
                    for (i = 0; i < this.vars.length; ++i) {
                        int finalI = i;
                        this.operations[3 + i] = () -> {
                            this.vindices[n] = this.vars[finalI].link(this, finalI);
                        };
                    }
                }
                for (i = 0; i < this.vars.length; ++i) {
                    if (this.vars[i].isInstantiated()) continue;
                    this.vars[i].unlink(this, i);
                    this.model.getEnvironment().save(this.operations[3 + i]);
                }
            }
        } else {
            throw new SolverException("Try to passivate a propagator already passive or reified.\n" + this + " of " + this.getConstraint());
        }
    }

    protected void forcePropagationOnBacktrack() {
        if (this.isPassive()) {
            this.state = (short)2;
        }
        this.model.getSolver().getEngine().propagateOnBacktrack(this);
    }

    public abstract ESat isEntailed();

    public boolean isCompletelyInstantiated() {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public int arity() {
        int arity = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            arity += this.vars[i].isInstantiated() ? 0 : 1;
        }
        return arity;
    }

    public int dynPriority() {
        int arity = 0;
        for (int i = 0; i < this.vars.length && arity <= 3; arity += this.vars[i].isInstantiated() ? 0 : 1, ++i) {
        }
        if (arity > 3) {
            return this.priority.priority;
        }
        return arity;
    }

    public void fails() throws ContradictionException {
        this.model.getSolver().throwsException(this, null, null);
    }

    @Override
    public int compareTo(Propagator o) {
        return this.ID - o.ID;
    }

    @Override
    public int getId() {
        return this.ID;
    }

    public Model getModel() {
        return this.model;
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        return o instanceof Propagator && ((Propagator)o).ID == this.ID;
    }

    public final V getVar(int i) {
        return this.vars[i];
    }

    public final V[] getVars() {
        return this.vars;
    }

    public int[] getVIndices() {
        return this.vindices;
    }

    public int getVIndice(int idx) {
        return this.vindices[idx];
    }

    public void setVIndices(int idx, int val) {
        this.vindices[idx] = val;
    }

    public final int getNbVars() {
        return this.vars.length;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final PropagatorPriority getPriority() {
        return this.priority;
    }

    public boolean isStateLess() {
        return this.state == 0;
    }

    public boolean isReifiedAndSilent() {
        return this.state == 1;
    }

    public boolean isActive() {
        return this.state == 2;
    }

    public boolean isPassive() {
        return this.state == 3;
    }

    public final boolean reactToFineEvent() {
        return this.reactToFineEvt;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append(this.getClass().getSimpleName()).append("(");
        int i = 0;
        if (this.vars.length >= 3) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 2) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 1) {
            st.append(this.vars[i++].getName());
        }
        if (i < this.vars.length) {
            if (this.vars.length > 4) {
                st.append(", ...");
            }
            st.append(", ").append(this.vars[this.vars.length - 1].getName());
        }
        st.append(')');
        return st.toString();
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar var, IEventType evt, int value) {
        boolean nrules = ruleStore.addPropagatorActivationRule(this);
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i] == var) continue;
            nrules |= ruleStore.addFullDomainRule((IntVar)this.vars[i]);
        }
        return nrules;
    }
}

