/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.sat.PropSat;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.cnf.ILogical;
import org.chocosolver.solver.constraints.nary.cnf.LogOp;
import org.chocosolver.solver.constraints.nary.cnf.LogicTreeToolBox;
import org.chocosolver.solver.constraints.reification.LocalConstructiveDisjunction;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public interface ISatFactory
extends ISelf<Model> {
    default public boolean addClauses(LogOp TREE) {
        ILogical tree = LogicTreeToolBox.toCNF(TREE, (Model)this._me());
        boolean ret = true;
        if (((Model)this._me()).boolVar(true).equals(tree)) {
            ret = this.addClauseTrue(((Model)this._me()).boolVar(true));
        } else if (((Model)this._me()).boolVar(false).equals(tree)) {
            ret = this.addClauseTrue(((Model)this._me()).boolVar(false));
        } else {
            ILogical[] clauses = !tree.isLit() && ((LogOp)tree).is(LogOp.Operator.AND) ? ((LogOp)tree).getChildren() : new ILogical[]{tree};
            for (int i = 0; i < clauses.length; ++i) {
                ILogical clause = clauses[i];
                if (clause.isLit()) {
                    BoolVar bv = (BoolVar)clause;
                    ret &= this.addClauseTrue(bv);
                    continue;
                }
                LogOp n = (LogOp)clause;
                BoolVar[] bvars = n.flattenBoolVar();
                if (((Model)this._me()).getSettings().enableSAT()) {
                    TIntArrayList lits = new TIntArrayList(bvars.length);
                    PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
                    sat.beforeAddingClauses();
                    for (int j = 0; j < bvars.length; ++j) {
                        lits.add(sat.makeLiteral(bvars[j], true));
                    }
                    ret &= sat.addClause(lits);
                    sat.afterAddingClauses();
                    continue;
                }
                ((Model)this._me()).sum(bvars, ">", 0).post();
                ret &= true;
            }
        }
        return ret;
    }

    default public boolean addClauses(BoolVar[] POSLITS, BoolVar[] NEGLITS) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] pos = new int[POSLITS.length];
            for (int i = 0; i < POSLITS.length; ++i) {
                pos[i] = sat.makeVar(POSLITS[i]);
            }
            int[] neg = new int[NEGLITS.length];
            for (int i = 0; i < NEGLITS.length; ++i) {
                neg[i] = sat.makeVar(NEGLITS[i]);
            }
            boolean add = sat.getSatSolver().addClause(pos, neg);
            sat.afterAddingClauses();
            return add;
        }
        int PL = POSLITS.length;
        int NL = NEGLITS.length;
        BoolVar[] LITS = new BoolVar[PL + NL];
        System.arraycopy(POSLITS, 0, LITS, 0, PL);
        for (int i = 0; i < NL; ++i) {
            LITS[i + PL] = NEGLITS[i].not();
        }
        ((Model)this._me()).sum(LITS, ">", 0).post();
        return true;
    }

    default public boolean addClauseTrue(BoolVar BOOLVAR) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addTrue(sat.makeVar(BOOLVAR));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)BOOLVAR, "=", 1).post();
        return true;
    }

    default public boolean addClauseFalse(BoolVar BOOLVAR) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addFalse(sat.makeVar(BOOLVAR));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)BOOLVAR, "=", 0).post();
        return true;
    }

    default public boolean addClausesBoolEq(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolEq(sat.makeVar(LEFT), sat.makeVar(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLe(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolLe(sat.makeVar(LEFT), sat.makeVar(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "<=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolLt(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolLt(sat.makeVar(LEFT), sat.makeVar(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "<", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolNot(BoolVar LEFT, BoolVar RIGHT) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolNot(sat.makeVar(LEFT), sat.makeVar(RIGHT));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "!=", RIGHT).post();
        return true;
    }

    default public boolean addClausesBoolOrArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addBoolOrArrayEqVar(vars, sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).max(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addBoolAndArrayEqVar(vars, sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).min(TARGET, BOOLVARS).post();
        return true;
    }

    default public boolean addClausesBoolOrEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolOrEqVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, ">", 0).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolAndEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolAndEqVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).arithm((IntVar)LEFT, "+", (IntVar)RIGHT, "=", 2).reifyWith(TARGET);
        return true;
    }

    default public boolean addClausesBoolXorEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        return this.addClausesBoolIsNeqVar(LEFT, RIGHT, TARGET);
    }

    default public boolean addClausesBoolIsEqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolIsEqVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).reifyXeqY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsNeqVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolIsNeqVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).reifyXneY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLeVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolIsLeVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).reifyXleY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolIsLtVar(BoolVar LEFT, BoolVar RIGHT, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = sat.getSatSolver().addBoolIsLtVar(sat.makeVar(LEFT), sat.makeVar(RIGHT), sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).reifyXltY(LEFT, RIGHT, TARGET);
        return true;
    }

    default public boolean addClausesBoolOrArrayEqualTrue(BoolVar[] BOOLVARS) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addBoolOrArrayEqualTrue(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).sum(BOOLVARS, ">", 0).post();
        return true;
    }

    default public boolean addClausesBoolAndArrayEqualFalse(BoolVar[] BOOLVARS) {
        return this.addClausesAtMostNMinusOne(BOOLVARS);
    }

    default public boolean addClausesAtMostOne(BoolVar[] BOOLVARS) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addAtMostOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).sum(BOOLVARS, "<", 2).post();
        return true;
    }

    default public boolean addClausesAtMostNMinusOne(BoolVar[] BOOLVARS) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addAtMostNMinusOne(vars);
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).sum(BOOLVARS, "<", BOOLVARS.length).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayGreaterEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addSumBoolArrayGreaterEqVar(vars, sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        ((Model)this._me()).sum(BOOLVARS, ">=", (IntVar)TARGET).post();
        return true;
    }

    default public boolean addClausesMaxBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            boolean add = sat.getSatSolver().addMaxBoolArrayLessEqVar(vars, sat.makeVar(TARGET));
            sat.afterAddingClauses();
            return add;
        }
        BoolVar max = ((Model)this._me()).boolVar(((Model)this._me()).generateName("bool_max"));
        ((Model)this._me()).max(max, BOOLVARS).post();
        max.le(TARGET).post();
        return true;
    }

    default public boolean addClausesSumBoolArrayLessEqVar(BoolVar[] BOOLVARS, BoolVar TARGET) {
        if (((Model)this._me()).getSettings().enableSAT()) {
            PropSat sat = ((Model)this._me()).getMinisat().getPropSat();
            sat.beforeAddingClauses();
            boolean add = false;
            if (BOOLVARS.length == 1) {
                add = this.addClausesBoolLe(BOOLVARS[0], TARGET);
            }
            int[] vars = new int[BOOLVARS.length];
            for (int i = 0; i < BOOLVARS.length; ++i) {
                vars[i] = sat.makeVar(BOOLVARS[i]);
            }
            sat.afterAddingClauses();
            return add |= sat.getSatSolver().addSumBoolArrayLessEqVar(vars, sat.makeVar(TARGET));
        }
        ((Model)this._me()).sum(BOOLVARS, "<=", (IntVar)TARGET).post();
        return true;
    }

    default public boolean addConstructiveDisjunction(Constraint ... cstrs) {
        new LocalConstructiveDisjunction(cstrs).post();
        return true;
    }
}

