/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.reification.PropXeqCReif;
import org.chocosolver.solver.constraints.reification.PropXeqYReif;
import org.chocosolver.solver.constraints.reification.PropXgtCReif;
import org.chocosolver.solver.constraints.reification.PropXinSReif;
import org.chocosolver.solver.constraints.reification.PropXltCReif;
import org.chocosolver.solver.constraints.reification.PropXltYCReif;
import org.chocosolver.solver.constraints.reification.PropXltYReif;
import org.chocosolver.solver.constraints.reification.PropXneCReif;
import org.chocosolver.solver.constraints.reification.PropXneYReif;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface IReificationFactory {
    default public void ifThenElse(Constraint ifCstr, Constraint thenCstr, Constraint elseCstr) {
        this.ifThenElse(ifCstr.reify(), thenCstr, elseCstr);
    }

    default public void ifThenElse(BoolVar ifVar, Constraint thenCstr, Constraint elseCstr) {
        this.ifThen(ifVar, thenCstr);
        this.ifThen(ifVar.not(), elseCstr);
    }

    default public void ifThen(Constraint ifCstr, Constraint thenCstr) {
        this.ifThen(ifCstr.reify(), thenCstr);
    }

    default public void ifThen(BoolVar ifVar, Constraint thenCstr) {
        if (ifVar.contains(1)) {
            Model s = ifVar.getModel();
            if (ifVar.isInstantiated()) {
                thenCstr.post();
            } else if (thenCstr.isSatisfied() == ESat.FALSE) {
                s.arithm((IntVar)ifVar, "=", 0).post();
            } else {
                s.arithm((IntVar)ifVar, "<=", thenCstr.reify()).post();
            }
        }
    }

    default public void ifOnlyIf(Constraint cstr1, Constraint cstr2) {
        this.reification(cstr1.reify(), cstr2);
    }

    default public void reification(BoolVar var, Constraint cstr) {
        Model s = var.getModel();
        ESat entail = cstr.isSatisfied();
        if (var.isInstantiatedTo(1)) {
            cstr.post();
        } else if (var.isInstantiatedTo(0)) {
            cstr.getOpposite().post();
        } else if (entail == ESat.TRUE) {
            s.arithm((IntVar)var, "=", 1).post();
        } else if (entail == ESat.FALSE) {
            s.arithm((IntVar)var, "=", 0).post();
        } else {
            cstr.reifyWith(var);
        }
    }

    default public void reifyXeqC(IntVar X, int C, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X = C)<=>B", new PropXeqCReif(X, C, B)));
    }

    default public void reifyXeqY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXeqC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXeqC(X, Y.getValue(), B);
        } else {
            Model model = X.getModel();
            model.post(new Constraint("(X = Y)<=>B", new PropXeqYReif(X, Y, B)));
        }
    }

    default public void reifyXneC(IntVar X, int C, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X != C)<=>B", new PropXneCReif(X, C, B)));
    }

    default public void reifyXneY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXneC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXneC(X, Y.getValue(), B);
        } else {
            Model model = X.getModel();
            model.post(new Constraint("(X != Y)<=>B", new PropXneYReif(X, Y, B)));
        }
    }

    default public void reifyXltC(IntVar X, int C, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X < C)<=>B", new PropXltCReif(X, C, B)));
    }

    default public void reifyXltY(IntVar X, IntVar Y, BoolVar B) {
        if (X.isAConstant()) {
            this.reifyXgtC(Y, X.getValue(), B);
        } else if (Y.isAConstant()) {
            this.reifyXltC(X, Y.getValue(), B);
        } else {
            Model model = X.getModel();
            model.post(new Constraint("(X < Y)<=>B", new PropXltYReif(X, Y, B)));
        }
    }

    default public void reifyXleY(IntVar X, IntVar Y, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X <= Y)<=>B", new PropXltYCReif(X, Y, 1, B)));
    }

    default public void reifyXltYC(IntVar X, IntVar Y, int C, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X < Y + C)<=>B", new PropXltYCReif(X, Y, C, B)));
    }

    default public void reifyXgtC(IntVar X, int C, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X > C)<=>B", new PropXgtCReif(X, C, B)));
    }

    default public void reifyXinS(IntVar X, IntIterableRangeSet S, BoolVar B) {
        Model model = X.getModel();
        model.post(new Constraint("(X \u2208 S)<=>B", new PropXinSReif(X, S, B)));
    }
}

