/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Arithmetic;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.binary.PropAbsolute;
import org.chocosolver.solver.constraints.binary.PropDistanceXYC;
import org.chocosolver.solver.constraints.binary.PropEqualXY_C;
import org.chocosolver.solver.constraints.binary.PropEqualX_Y;
import org.chocosolver.solver.constraints.binary.PropScale;
import org.chocosolver.solver.constraints.binary.PropSquare;
import org.chocosolver.solver.constraints.binary.element.ElementFactory;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.TuplesFactory;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC2001;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3bitrm;
import org.chocosolver.solver.constraints.extension.binary.PropBinAC3rm;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.constraints.extension.binary.PropBinFC;
import org.chocosolver.solver.constraints.extension.nary.PropCompactTable;
import org.chocosolver.solver.constraints.extension.nary.PropLargeFC;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC2001;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC2001Positive;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC3rm;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGAC3rmPositive;
import org.chocosolver.solver.constraints.extension.nary.PropLargeGACSTRPos;
import org.chocosolver.solver.constraints.extension.nary.PropLargeMDDC;
import org.chocosolver.solver.constraints.extension.nary.PropTableStr2;
import org.chocosolver.solver.constraints.nary.PropDiffN;
import org.chocosolver.solver.constraints.nary.PropIntValuePrecedeChain;
import org.chocosolver.solver.constraints.nary.PropKLoops;
import org.chocosolver.solver.constraints.nary.PropKnapsack;
import org.chocosolver.solver.constraints.nary.alldifferent.AllDifferent;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.Condition;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiffInst;
import org.chocosolver.solver.constraints.nary.alldifferent.conditions.PropCondAllDiff_AC;
import org.chocosolver.solver.constraints.nary.among.PropAmongGAC;
import org.chocosolver.solver.constraints.nary.automata.CostRegular;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.PropMultiCostRegular;
import org.chocosolver.solver.constraints.nary.automata.PropRegular;
import org.chocosolver.solver.constraints.nary.binPacking.PropItemToLoad;
import org.chocosolver.solver.constraints.nary.binPacking.PropLoadToItem;
import org.chocosolver.solver.constraints.nary.channeling.PropBitChanneling;
import org.chocosolver.solver.constraints.nary.channeling.PropClauseChanneling;
import org.chocosolver.solver.constraints.nary.channeling.PropEnumDomainChanneling;
import org.chocosolver.solver.constraints.nary.channeling.PropInverseChannelAC;
import org.chocosolver.solver.constraints.nary.channeling.PropInverseChannelBC;
import org.chocosolver.solver.constraints.nary.circuit.CircuitConf;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuitSCC;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuit_AntiArboFiltering;
import org.chocosolver.solver.constraints.nary.circuit.PropCircuit_ArboFiltering;
import org.chocosolver.solver.constraints.nary.circuit.PropNoSubtour;
import org.chocosolver.solver.constraints.nary.circuit.PropSubcircuit;
import org.chocosolver.solver.constraints.nary.circuit.PropSubcircuitDominatorFilter;
import org.chocosolver.solver.constraints.nary.count.PropCountVar;
import org.chocosolver.solver.constraints.nary.count.PropCount_AC;
import org.chocosolver.solver.constraints.nary.cumulative.Cumulative;
import org.chocosolver.solver.constraints.nary.element.PropElementV_fast;
import org.chocosolver.solver.constraints.nary.globalcardinality.GlobalCardinality;
import org.chocosolver.solver.constraints.nary.lex.PropLex;
import org.chocosolver.solver.constraints.nary.lex.PropLexChain;
import org.chocosolver.solver.constraints.nary.min_max.PropBoolMax;
import org.chocosolver.solver.constraints.nary.min_max.PropBoolMin;
import org.chocosolver.solver.constraints.nary.min_max.PropMax;
import org.chocosolver.solver.constraints.nary.min_max.PropMin;
import org.chocosolver.solver.constraints.nary.nValue.PropAMNV;
import org.chocosolver.solver.constraints.nary.nValue.PropAtLeastNValues;
import org.chocosolver.solver.constraints.nary.nValue.PropAtLeastNValues_AC;
import org.chocosolver.solver.constraints.nary.nValue.PropAtMostNValues;
import org.chocosolver.solver.constraints.nary.nValue.amnv.graph.Gci;
import org.chocosolver.solver.constraints.nary.nValue.amnv.mis.MDRk;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R1;
import org.chocosolver.solver.constraints.nary.nValue.amnv.rules.R3;
import org.chocosolver.solver.constraints.nary.sort.PropKeysorting;
import org.chocosolver.solver.constraints.nary.sum.IntLinCombFactory;
import org.chocosolver.solver.constraints.nary.tree.PropAntiArborescences;
import org.chocosolver.solver.constraints.ternary.PropDistanceXYZ;
import org.chocosolver.solver.constraints.ternary.PropDivXYZ;
import org.chocosolver.solver.constraints.ternary.PropMaxBC;
import org.chocosolver.solver.constraints.ternary.PropMinBC;
import org.chocosolver.solver.constraints.ternary.PropTimesNaive;
import org.chocosolver.solver.constraints.unary.Member;
import org.chocosolver.solver.constraints.unary.NotMember;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.util.objects.graphs.MultivaluedDecisionDiagram;
import org.chocosolver.util.tools.ArrayUtils;
import org.chocosolver.util.tools.VariableUtils;

public interface IIntConstraintFactory
extends ISelf<Model> {
    default public Constraint arithm(IntVar var, String op, int cste) {
        return new Arithmetic(var, Operator.get(op), cste);
    }

    default public Constraint member(IntVar var, int[] table) {
        return new Member(var, table);
    }

    default public Constraint member(IntVar var, int lb, int ub) {
        return new Member(var, lb, ub);
    }

    default public Constraint not(Constraint cstr) {
        return cstr.getOpposite();
    }

    default public Constraint notMember(IntVar var, int[] table) {
        return new NotMember(var, table);
    }

    default public Constraint notMember(IntVar var, int lb, int ub) {
        return new NotMember(var, lb, ub);
    }

    default public Constraint absolute(IntVar var1, IntVar var2) {
        if (!1.$assertionsDisabled && var1.getModel() != var2.getModel()) {
            throw new AssertionError();
        }
        return new Constraint("Absolute", new PropAbsolute(var1, var2));
    }

    default public Constraint arithm(IntVar var1, String op, IntVar var2) {
        if (var2.isInstantiated()) {
            return this.arithm(var1, op, var2.getValue());
        }
        if (var1.isInstantiated()) {
            return this.arithm(var2, Operator.getFlip(op), var1.getValue());
        }
        return new Arithmetic(var1, Operator.get(op), var2);
    }

    default public Constraint arithm(IntVar var1, String op1, IntVar var2, String op2, int cste) {
        if (op1.equals("*") || op1.equals("/") || op2.equals("*") || op2.equals("/")) {
            switch (op1) {
                case "*": {
                    if (Operator.EQ.name().equals(op2)) {
                        return this.times(var1, var2, cste);
                    }
                    int[] bounds = VariableUtils.boundsForMultiplication(var1, var2);
                    IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                    ((Model)this._me()).times(var1, var2, var4).post();
                    return this.arithm(var4, op2, cste);
                }
                case "/": {
                    if (Operator.EQ.name().equals(op2)) {
                        return this.div(var1, var2, ((Model)this._me()).intVar(cste));
                    }
                    int[] bounds = VariableUtils.boundsForDivision(var1, var2);
                    IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                    ((Model)this._me()).div(var1, var2, var4).post();
                    return this.arithm(var4, op2, cste);
                }
            }
            switch (op2) {
                default: {
                    throw new SolverException("Unknown operators for arithm constraint");
                }
                case "*": {
                    if (Operator.EQ.name().equals(op1)) {
                        return this.times(var2, cste, var1);
                    }
                    int[] bounds = VariableUtils.boundsForMultiplication(var2, ((Model)this._me()).intVar(cste));
                    IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                    ((Model)this._me()).times(var2, cste, var4).post();
                    return this.arithm(var1, op1, var4);
                }
                case "/": 
            }
            if (Operator.EQ.name().equals(op1)) {
                return this.div(var2, ((Model)this._me()).intVar(cste), var1);
            }
            int[] bounds = VariableUtils.boundsForDivision(var2, ((Model)this._me()).intVar(cste));
            IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
            ((Model)this._me()).div(var2, ((Model)this._me()).intVar(cste), var4).post();
            return this.arithm(var1, op1, var4);
        }
        if (var2.isInstantiated()) {
            if ("+".equals(op1)) {
                return this.arithm(var1, op2, cste - var2.getValue());
            }
            if ("-".equals(op1)) {
                return this.arithm(var1, op2, cste + var2.getValue());
            }
        }
        if (var1.isInstantiated()) {
            if ("+".equals(op1)) {
                return this.arithm(var2, op2, cste - var1.getValue());
            }
            if ("-".equals(op1)) {
                return this.arithm(var2, Operator.getFlip(op2), var1.getValue() - cste);
            }
        }
        return new Arithmetic(var1, Operator.get(op1), var2, Operator.get(op2), cste);
    }

    default public Constraint distance(IntVar var1, IntVar var2, String op, int cste) {
        if (!1.$assertionsDisabled && var1.getModel() != var2.getModel()) {
            throw new AssertionError();
        }
        Operator operator = Operator.get(op);
        if (operator != Operator.EQ && operator != Operator.GT && operator != Operator.LT && operator != Operator.NQ) {
            throw new SolverException("Unexpected operator for distance");
        }
        if (cste < 0) {
            switch (operator) {
                default: 
            }
            throw new SolverException("Invalid PropDistanceXYC operator " + (Object)((Object)operator));
        }
        return new Constraint("DistanceXYC " + operator.name(), new PropDistanceXYC(ArrayUtils.toArray(var1, var2), operator, cste));
    }

    default public Constraint element(IntVar value, int[] table, IntVar index, int offset) {
        return ElementFactory.detect(value, table, index, offset);
    }

    default public Constraint element(IntVar value, int[] table, IntVar index) {
        return this.element(value, table, index, 0);
    }

    default public Constraint square(IntVar var1, IntVar var2) {
        if (!1.$assertionsDisabled && var1.getModel() != var2.getModel()) {
            throw new AssertionError();
        }
        return new Constraint("Square", new PropSquare(var1, var2));
    }

    default public Constraint table(IntVar var1, IntVar var2, Tuples tuples) {
        return this.table(var1, var2, tuples, "AC3bit+rm");
    }

    default public Constraint table(IntVar var1, IntVar var2, Tuples tuples, String algo) {
        PropBinCSP p;
        switch (algo) {
            case "AC2001": {
                p = new PropBinAC2001(var1, var2, tuples);
                break;
            }
            case "FC": {
                p = new PropBinFC(var1, var2, tuples);
                break;
            }
            case "AC3": {
                p = new PropBinAC3(var1, var2, tuples);
                break;
            }
            case "AC3rm": {
                p = new PropBinAC3rm(var1, var2, tuples);
                break;
            }
            case "AC3bit+rm": {
                p = new PropBinAC3bitrm(var1, var2, tuples);
                break;
            }
            default: {
                throw new SolverException("Table algorithm " + algo + " is unkown");
            }
        }
        return new Constraint("TableBin(" + algo + ")", p);
    }

    default public Constraint times(IntVar X, int Y, IntVar Z) {
        if (Y == 0) {
            return this.arithm(Z, "=", 0);
        }
        if (Y == 1) {
            return this.arithm(X, "=", Z);
        }
        if (Y < 0) {
            return this.times(X.getModel().intMinusView(X), -Y, Z);
        }
        return new Constraint("Times", new PropScale(X, Y, Z));
    }

    default public Constraint times(IntVar X, IntVar Y, int Z) {
        return this.times(X, Y, X.getModel().intVar(Z));
    }

    default public Constraint arithm(IntVar var1, String op1, IntVar var2, String op2, IntVar var3) {
        switch (op1) {
            case "+": {
                return this.scalar(new IntVar[]{var1, var2}, new int[]{1, 1}, op2, var3);
            }
            case "-": {
                return this.scalar(new IntVar[]{var1, var2}, new int[]{1, -1}, op2, var3);
            }
            case "*": {
                if (Operator.EQ.name().equals(op2)) {
                    return this.times(var1, var2, var3);
                }
                int[] bounds = VariableUtils.boundsForMultiplication(var1, var2);
                IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                ((Model)this._me()).times(var1, var2, var4).post();
                return this.arithm(var4, op2, var3);
            }
            case "/": {
                if (Operator.EQ.name().equals(op2)) {
                    return this.div(var1, var2, var3);
                }
                int[] bounds = VariableUtils.boundsForDivision(var1, var2);
                IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                ((Model)this._me()).div(var1, var2, var4).post();
                return this.arithm(var4, op2, var3);
            }
        }
        switch (op2) {
            case "*": {
                if (Operator.EQ.name().equals(op1)) {
                    return this.times(var2, var3, var1);
                }
                int[] bounds = VariableUtils.boundsForMultiplication(var2, var3);
                IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                ((Model)this._me()).times(var2, var3, var4).post();
                return this.arithm(var1, op1, var4);
            }
            case "/": {
                if (Operator.EQ.name().equals(op1)) {
                    return this.div(var2, var3, var1);
                }
                int[] bounds = VariableUtils.boundsForDivision(var2, var3);
                IntVar var4 = ((Model)this._me()).intVar(bounds[0], bounds[1]);
                ((Model)this._me()).div(var2, var3, var4).post();
                return this.arithm(var1, op1, var4);
            }
            case "+": {
                return this.scalar(new IntVar[]{var1, var3}, new int[]{1, -1}, op1, var2);
            }
            case "-": {
                return this.scalar(new IntVar[]{var1, var3}, new int[]{1, 1}, op1, var2);
            }
        }
        throw new SolverException("Unknown operators for arithm constraint");
    }

    default public Constraint distance(IntVar var1, IntVar var2, String op, IntVar var3) {
        Operator oper = Operator.get(op);
        if (oper != Operator.EQ && oper != Operator.GT && oper != Operator.LT) {
            throw new SolverException("Unexpected operator for distance");
        }
        return new Constraint("DistanceXYZ " + op, new PropDistanceXYZ(ArrayUtils.toArray(var1, var2, var3), oper));
    }

    default public Constraint div(IntVar dividend, IntVar divisor, IntVar result) {
        return new Constraint("DivisionEucl", new PropDivXYZ(dividend, divisor, result));
    }

    default public Constraint max(IntVar max, IntVar var1, IntVar var2) {
        return new Constraint("Max", new PropMaxBC(max, var1, var2));
    }

    default public Constraint min(IntVar min, IntVar var1, IntVar var2) {
        return new Constraint("Min", new PropMinBC(min, var1, var2));
    }

    default public Constraint mod(IntVar X, IntVar Y, IntVar Z) {
        int xl = Math.abs(X.getLB());
        int xu = Math.abs(X.getUB());
        int b = Math.max(xl, xu);
        Model model = X.getModel();
        IntVar t1 = model.intVar(model.generateName("T1_"), -b, b, true);
        IntVar t2 = model.intVar(model.generateName("T2_"), -b, b, true);
        this.div(X, Y, t1).post();
        this.times(t1, Y, t2).post();
        return this.sum(new IntVar[]{Z, t2}, "=", X);
    }

    default public Constraint times(IntVar X, IntVar Y, IntVar Z) {
        if (Y.isInstantiated()) {
            return this.times(X, Y.getValue(), Z);
        }
        if (X.isInstantiated()) {
            return this.times(Y, X.getValue(), Z);
        }
        if (TuplesFactory.canBeTupled(X, Y, Z)) {
            return this.table(new IntVar[]{X, Y, Z}, TuplesFactory.times(X, Y, Z));
        }
        return new Constraint("Times", new PropTimesNaive(X, Y, Z));
    }

    default public Constraint allDifferent(IntVar ... vars) {
        return this.allDifferent(vars, "DEFAULT");
    }

    default public Constraint allDifferent(IntVar[] vars, String CONSISTENCY) {
        if (vars.length <= 1) {
            return ((Model)this._me()).trueConstraint();
        }
        return new AllDifferent(vars, CONSISTENCY);
    }

    default public Constraint allDifferentUnderCondition(IntVar[] vars, Condition condition, boolean singleCondition) {
        if (singleCondition) {
            return new Constraint("AllDifferent" + condition, new PropCondAllDiffInst(vars, condition, singleCondition), new PropCondAllDiff_AC(vars, condition));
        }
        return new Constraint("AllDifferent" + condition, new PropCondAllDiffInst(vars, condition, singleCondition));
    }

    default public Constraint allDifferentExcept0(IntVar[] vars) {
        return this.allDifferentUnderCondition(vars, Condition.EXCEPT_0, true);
    }

    default public Constraint allEqual(IntVar ... vars) {
        return this.atMostNValues(vars, ((Model)this._me()).intVar(1), false);
    }

    default public Constraint notAllEqual(IntVar ... vars) {
        return this.atLeastNValues(vars, ((Model)this._me()).intVar(2), false);
    }

    default public Constraint among(IntVar nbVar, IntVar[] vars, int[] values) {
        int[] vls = new TIntHashSet(values).toArray();
        Arrays.sort(vls);
        return new Constraint("Among", new PropAmongGAC(ArrayUtils.concat(vars, nbVar), vls));
    }

    default public Constraint and(BoolVar ... bools) {
        Model s = bools[0].getModel();
        IntVar sum = s.intVar(0, bools.length, true);
        s.sum(bools, "=", sum).post();
        return s.arithm(sum, "=", bools.length);
    }

    default public Constraint and(Constraint ... cstrs) {
        BoolVar[] bools = new BoolVar[cstrs.length];
        for (int i = 0; i < cstrs.length; ++i) {
            bools[i] = cstrs[i].reify();
        }
        return this.and(bools);
    }

    default public Constraint atLeastNValues(IntVar[] vars, IntVar nValues, boolean AC) {
        int[] vals = this.getDomainUnion(vars);
        if (AC) {
            return new Constraint("AtLeastNValues", new PropAtLeastNValues(vars, vals, nValues), new PropAtLeastNValues_AC(vars, vals, nValues));
        }
        return new Constraint("AtLeastNValues", new PropAtLeastNValues(vars, vals, nValues));
    }

    default public Constraint atMostNValues(IntVar[] vars, IntVar nValues, boolean STRONG) {
        int[] vals = this.getDomainUnion(vars);
        if (STRONG) {
            Gci gci = new Gci(vars);
            R[] rules = new R[]{new R1(), new R3(vars.length, nValues.getModel())};
            return new Constraint("AtMostNValues", new PropAtMostNValues(vars, vals, nValues), new PropAMNV(vars, nValues, gci, new MDRk(gci), rules));
        }
        return new Constraint("AtMostNValues", new PropAtMostNValues(vars, vals, nValues));
    }

    default public Constraint binPacking(IntVar[] itemBin, int[] itemSize, IntVar[] binLoad, int offset) {
        if (itemBin.length != itemSize.length) {
            throw new SolverException("itemBin and itemSize arrays should have same size");
        }
        Model model = itemBin[0].getModel();
        int sum = 0;
        for (int is : itemSize) {
            sum += is;
        }
        return Constraint.merge("BinPacking", new Constraint("BinPacking", new PropItemToLoad(itemBin, itemSize, binLoad, offset), new PropLoadToItem(itemBin, itemSize, binLoad, offset)), model.sum(binLoad, "=", sum));
    }

    default public Constraint boolsIntChanneling(BoolVar[] bVars, IntVar var, int offset) {
        if (var.hasEnumeratedDomain()) {
            return new Constraint("DomainChanneling", new PropEnumDomainChanneling(bVars, var, offset));
        }
        IntVar enumV = var.getModel().intVar(var.getName() + "_enumImage", var.getLB(), var.getUB(), false);
        return new Constraint("BoolChanneling", new PropEnumDomainChanneling(bVars, enumV, offset), new PropEqualX_Y(var, enumV));
    }

    default public Constraint bitsIntChanneling(BoolVar[] bits, IntVar var) {
        return new Constraint("bitsIntChanneling", new PropBitChanneling(var, bits));
    }

    default public Constraint clausesIntChanneling(IntVar var, BoolVar[] eVars, BoolVar[] lVars) {
        return new Constraint("clausesIntChanneling", new PropClauseChanneling(var, eVars, lVars));
    }

    default public Constraint circuit(IntVar[] vars) {
        return this.circuit(vars, 0);
    }

    default public Constraint circuit(IntVar[] vars, int offset) {
        return this.circuit(vars, offset, CircuitConf.RD);
    }

    default public Constraint circuit(IntVar[] vars, int offset, CircuitConf conf) {
        Propagator[] props = conf == CircuitConf.LIGHT ? new Propagator[]{new PropNoSubtour(vars, offset)} : new Propagator[]{new PropNoSubtour(vars, offset), new PropCircuit_ArboFiltering(vars, offset, conf), new PropCircuit_AntiArboFiltering(vars, offset, conf), new PropCircuitSCC(vars, offset, conf)};
        return new Constraint("Circuit", ArrayUtils.append(this.allDifferent((IntVar[])vars, (String)"AC").propagators, props));
    }

    default public Constraint costRegular(IntVar[] vars, IntVar cost, ICostAutomaton costAutomaton) {
        return new CostRegular(vars, cost, costAutomaton);
    }

    default public Constraint count(int value, IntVar[] vars, IntVar limit) {
        return new Constraint("Count", new PropCount_AC(vars, value, limit));
    }

    default public Constraint count(IntVar value, IntVar[] vars, IntVar limit) {
        if (value.isInstantiated()) {
            return this.count(value.getValue(), vars, limit);
        }
        if (value.hasEnumeratedDomain()) {
            return new Constraint("Count", new PropCountVar(vars, value, limit));
        }
        Model model = value.getModel();
        IntVar Evalue = model.intVar(model.generateName("COUNT_"), value.getLB(), value.getUB(), false);
        return new Constraint("Count", new PropEqualX_Y(Evalue, value), new PropCountVar(vars, Evalue, limit));
    }

    default public Constraint cumulative(Task[] tasks, IntVar[] heights, IntVar capacity) {
        return this.cumulative(tasks, heights, capacity, true);
    }

    default public Constraint cumulative(Task[] tasks, IntVar[] heights, IntVar capacity, boolean incremental) {
        return this.cumulative(tasks, heights, capacity, incremental, Cumulative.Filter.DEFAULT);
    }

    default public Constraint cumulative(Task[] tasks, IntVar[] heights, IntVar capacity, boolean incremental, Cumulative.Filter ... filters) {
        if (tasks.length != heights.length) {
            throw new SolverException("Tasks and heights arrays should have same size");
        }
        int nbUseFull = 0;
        for (int h = 0; h < heights.length; ++h) {
            if (heights[h].getUB() <= 0 || tasks[h].getDuration().getUB() <= 0) continue;
            ++nbUseFull;
        }
        if (nbUseFull < tasks.length) {
            if (nbUseFull == 0) {
                return this.arithm(capacity, ">=", 0);
            }
            Task[] T2 = new Task[nbUseFull];
            IntVar[] H2 = new IntVar[nbUseFull];
            int idx = 0;
            for (int h = 0; h < heights.length; ++h) {
                if (heights[h].getUB() <= 0 || tasks[h].getDuration().getUB() <= 0) continue;
                T2[idx] = tasks[h];
                H2[idx] = heights[h];
                ++idx;
            }
            tasks = T2;
            heights = H2;
        }
        return new Cumulative(tasks, heights, capacity, incremental, filters);
    }

    default public Constraint diffN(IntVar[] X, IntVar[] Y, IntVar[] width, IntVar[] height, boolean addCumulativeReasoning) {
        Model model = X[0].getModel();
        Constraint diffNCons = new Constraint("DiffN", new PropDiffN(X, Y, width, height, false), new PropDiffN(X, Y, width, height, false));
        if (addCumulativeReasoning) {
            IntVar[] EX = new IntVar[X.length];
            IntVar[] EY = new IntVar[X.length];
            Task[] TX = new Task[X.length];
            Task[] TY = new Task[X.length];
            int minx = 0x3FFFFFFF;
            int maxx = -1073741824;
            int miny = 0x3FFFFFFF;
            int maxy = -1073741824;
            for (int i = 0; i < X.length; ++i) {
                EX[i] = model.intVar(model.generateName("diffN_"), X[i].getLB() + width[i].getLB(), X[i].getUB() + width[i].getUB(), true);
                EY[i] = model.intVar(model.generateName("diffN_"), Y[i].getLB() + height[i].getLB(), Y[i].getUB() + height[i].getUB(), true);
                TX[i] = new Task(X[i], width[i], EX[i]);
                TY[i] = new Task(Y[i], height[i], EY[i]);
                minx = Math.min(minx, X[i].getLB());
                miny = Math.min(miny, Y[i].getLB());
                maxx = Math.max(maxx, X[i].getUB() + width[i].getUB());
                maxy = Math.max(maxy, Y[i].getUB() + height[i].getUB());
            }
            IntVar maxX = model.intVar(model.generateName("diffN_"), minx, maxx, true);
            IntVar minX = model.intVar(model.generateName("diffN_"), minx, maxx, true);
            IntVar diffX = model.intVar(model.generateName("diffN_"), 0, maxx - minx, true);
            IntVar maxY = model.intVar(model.generateName("diffN_"), miny, maxy, true);
            IntVar minY = model.intVar(model.generateName("diffN_"), miny, maxy, true);
            IntVar diffY = model.intVar(model.generateName("diffN_"), 0, maxy - miny, true);
            return Constraint.merge("DiffNWithCumulative", diffNCons, this.min(minX, X), this.max(maxX, EX), this.scalar(new IntVar[]{maxX, minX}, new int[]{1, -1}, "=", diffX), this.cumulative(TX, height, diffY), this.min(minY, Y), this.max(maxY, EY), this.scalar(new IntVar[]{maxY, minY}, new int[]{1, -1}, "=", diffY), this.cumulative(TY, width, diffX));
        }
        return diffNCons;
    }

    default public Constraint element(IntVar value, IntVar[] table, IntVar index, int offset) {
        return new Constraint("Element", new PropElementV_fast(value, table, index, offset, true));
    }

    default public Constraint globalCardinality(IntVar[] vars, int[] values, IntVar[] occurrences, boolean closed) {
        if (!1.$assertionsDisabled && values.length != occurrences.length) {
            throw new AssertionError();
        }
        if (!closed) {
            return new GlobalCardinality(vars, values, occurrences);
        }
        TIntArrayList toAdd = new TIntArrayList();
        TIntHashSet givenValues = new TIntHashSet();
        for (int i : values) {
            if (!1.$assertionsDisabled && givenValues.contains(i)) {
                throw new AssertionError();
            }
            givenValues.add(i);
        }
        for (IntVar var : vars) {
            int ub = var.getUB();
            int k = var.getLB();
            while (k <= ub) {
                if (!givenValues.contains(k) && !toAdd.contains(k)) {
                    toAdd.add(k);
                }
                k = var.nextValue(k);
            }
        }
        if (toAdd.size() > 0) {
            int n = values.length + toAdd.size();
            int[] v2 = new int[n];
            IntVar[] cards = new IntVar[n];
            System.arraycopy(values, 0, v2, 0, values.length);
            System.arraycopy(occurrences, 0, cards, 0, values.length);
            for (int i = values.length; i < n; ++i) {
                v2[i] = toAdd.get(i - values.length);
                cards[i] = vars[0].getModel().intVar(0);
            }
            return new GlobalCardinality(vars, v2, cards);
        }
        return new GlobalCardinality(vars, values, occurrences);
    }

    default public Constraint inverseChanneling(IntVar[] vars1, IntVar[] vars2) {
        return this.inverseChanneling(vars1, vars2, 0, 0);
    }

    default public Constraint inverseChanneling(IntVar[] vars1, IntVar[] vars2, int offset1, int offset2) {
        if (vars1.length != vars2.length) {
            throw new SolverException(Arrays.toString(vars1) + " and " + Arrays.toString(vars2) + " should have same size");
        }
        boolean allEnum = true;
        for (int i = 0; i < vars1.length && allEnum; ++i) {
            if (vars1[i].hasEnumeratedDomain() && vars2[i].hasEnumeratedDomain()) continue;
            allEnum = false;
        }
        Propagator ip = allEnum ? new PropInverseChannelAC(vars1, vars2, offset1, offset2) : new PropInverseChannelBC(vars1, vars2, offset1, offset2);
        return new Constraint("InverseChanneling", ArrayUtils.append(this.allDifferent(vars1, "").getPropagators(), this.allDifferent(vars2, "").getPropagators(), {ip}));
    }

    default public Constraint intValuePrecedeChain(IntVar[] X, int S, int T) {
        return new Constraint("int_value_precede", new PropIntValuePrecedeChain(X, S, T));
    }

    default public Constraint intValuePrecedeChain(IntVar[] X, int[] V) {
        if (V.length > 1) {
            TIntHashSet values = new TIntHashSet();
            Propagator[] ps = new PropIntValuePrecedeChain[V.length - 1];
            values.add(V[0]);
            for (int i = 1; i < V.length; ++i) {
                if (values.contains(V[i])) {
                    throw new SolverException("\"int_value_precede\" requires V to be made of distinct values");
                }
                values.add(V[i]);
                ps[i - 1] = new PropIntValuePrecedeChain(X, V[i - 1], V[i]);
            }
            return new Constraint("int_value_precede", ps);
        }
        return ((Model)this._me()).trueConstraint();
    }

    default public Constraint knapsack(IntVar[] occurrences, IntVar weightSum, IntVar energySum, int[] weight, int[] energy) {
        return new Constraint("Knapsack", ArrayUtils.append(this.scalar((IntVar[])occurrences, (int[])weight, (String)"=", (IntVar)weightSum).propagators, this.scalar((IntVar[])occurrences, (int[])energy, (String)"=", (IntVar)energySum).propagators, {new PropKnapsack(occurrences, weightSum, energySum, weight, energy)}));
    }

    default public Constraint keySort(IntVar[][] vars, IntVar[] PERMvars, IntVar[][] SORTEDvars, int K) {
        if (PERMvars == null) {
            int n = vars.length;
            PERMvars = new IntVar[n];
            for (int p = 0; p < n; ++p) {
                PERMvars[p] = vars[0][0].getModel().intVar("p_" + (p + 1), 1, n, true);
            }
        }
        return new Constraint("keySort", new PropKeysorting(vars, SORTEDvars, PERMvars, K));
    }

    default public Constraint lexChainLess(IntVar[] ... vars) {
        return new Constraint("LexChain(<) ", new PropLexChain(vars, true));
    }

    default public Constraint lexChainLessEq(IntVar[] ... vars) {
        return new Constraint("LexChain(<=)", new PropLexChain(vars, false));
    }

    default public Constraint lexLess(IntVar[] vars1, IntVar[] vars2) {
        return new Constraint("Lex(<)", new PropLex(vars1, vars2, true));
    }

    default public Constraint lexLessEq(IntVar[] vars1, IntVar[] vars2) {
        return new Constraint("Lex(<=)", new PropLex(vars1, vars2, false));
    }

    default public Constraint max(IntVar max, IntVar[] vars) {
        if (vars.length == 2) {
            return this.max(max, vars[0], vars[1]);
        }
        return new Constraint("Max", new PropMax(vars, max));
    }

    default public Constraint max(BoolVar max, BoolVar[] vars) {
        return new Constraint("MaxOverBools", new PropBoolMax(vars, max));
    }

    default public Constraint mddc(IntVar[] vars, MultivaluedDecisionDiagram MDD) {
        return new Constraint("mddc", new PropLargeMDDC(MDD, vars));
    }

    default public Constraint min(IntVar min, IntVar[] vars) {
        if (vars.length == 2) {
            return this.min(min, vars[0], vars[1]);
        }
        return new Constraint("Min", new PropMin(vars, min));
    }

    default public Constraint min(BoolVar min, BoolVar[] vars) {
        return new Constraint("MinOverBools", new PropBoolMin(vars, min));
    }

    default public Constraint multiCostRegular(IntVar[] vars, IntVar[] costVars, ICostAutomaton costAutomaton) {
        return new Constraint("MultiCostRegular", new PropMultiCostRegular(vars, costVars, costAutomaton));
    }

    default public Constraint nValues(IntVar[] vars, IntVar nValues) {
        int[] vals = this.getDomainUnion(vars);
        Gci gci = new Gci(vars);
        R[] rules = new R[]{new R1(), new R3(vars.length, nValues.getModel())};
        return new Constraint("nValue", new PropAtLeastNValues(vars, vals, nValues), new PropAtMostNValues(vars, vals, nValues), new PropAMNV(vars, nValues, gci, new MDRk(gci), rules));
    }

    default public Constraint or(BoolVar ... bools) {
        Model s = bools[0].getModel();
        IntVar sum = s.intVar(0, bools.length, true);
        s.sum(bools, "=", sum).post();
        return s.arithm(sum, ">=", 1);
    }

    default public Constraint or(Constraint ... cstrs) {
        BoolVar[] bools = new BoolVar[cstrs.length];
        for (int i = 0; i < cstrs.length; ++i) {
            bools[i] = cstrs[i].reify();
        }
        return this.or(bools);
    }

    default public Constraint path(IntVar[] vars, IntVar start, IntVar end) {
        return this.path(vars, start, end, 0);
    }

    default public Constraint path(IntVar[] vars, IntVar start, IntVar end, int offset) {
        if (!(1.$assertionsDisabled || start != null && end != null && vars != null)) {
            throw new AssertionError();
        }
        switch (vars.length) {
            case 0: {
                throw new SolverException("|vars| Should be strictly greater than 0");
            }
            case 1: {
                return Constraint.merge("path", this.arithm(start, "=", offset), this.arithm(end, "=", offset), this.arithm(vars[0], "=", 1 + offset));
            }
        }
        if (start == end) {
            return start.getModel().falseConstraint();
        }
        return Constraint.merge("path", this.arithm(start, "!=", end), this.circuit(ArrayUtils.concat(vars, start), offset), this.element(end.getModel().intVar(vars.length + offset), vars, end, offset));
    }

    default public Constraint regular(IntVar[] vars, IAutomaton automaton) {
        return new Constraint("Regular", new PropRegular(vars, automaton));
    }

    default public Constraint scalar(IntVar[] vars, int[] coeffs, String operator, int scalar) {
        if (!1.$assertionsDisabled && vars.length <= 0) {
            throw new AssertionError();
        }
        Model s = vars[0].getModel();
        IntVar scalarVar = s.intVar(scalar);
        return this.scalar(vars, coeffs, operator, scalarVar);
    }

    default public Constraint scalar(IntVar[] vars, int[] coeffs, String operator, IntVar scalar) {
        if (vars.length != coeffs.length) {
            throw new SolverException("vars and coeffs arrays should have same size");
        }
        return IntLinCombFactory.reduce(vars, coeffs, Operator.get(operator), scalar);
    }

    default public Constraint sort(IntVar[] vars, IntVar[] sortedVars) {
        if (vars.length != sortedVars.length) {
            throw new SolverException("vars and sortedVars arrays should have same size");
        }
        IntVar[][] X = new IntVar[vars.length][1];
        IntVar[][] Y = new IntVar[sortedVars.length][1];
        for (int i = 0; i < vars.length; ++i) {
            X[i][0] = vars[i];
            Y[i][0] = sortedVars[i];
        }
        return this.keySort(X, null, Y, 1);
    }

    default public Constraint subCircuit(IntVar[] vars, int offset, IntVar subCircuitLength) {
        int n = vars.length;
        Model model = vars[0].getModel();
        IntVar nbLoops = model.intVar("nLoops", 0, n, true);
        return new Constraint("SubCircuit", ArrayUtils.append(this.allDifferent(vars, "AC").getPropagators(), ArrayUtils.toArray(new PropEqualXY_C(new IntVar[]{nbLoops, subCircuitLength}, n), new PropKLoops(vars, offset, nbLoops), new PropSubcircuit(vars, offset, subCircuitLength), new PropSubcircuitDominatorFilter(vars, offset, true))));
    }

    default public Constraint subPath(IntVar[] vars, IntVar start, IntVar end, int offset, IntVar SIZE) {
        if (!(1.$assertionsDisabled || start != null && end != null && vars != null)) {
            throw new AssertionError();
        }
        switch (vars.length) {
            case 0: {
                throw new SolverException("|vars| Should be strictly greater than 0");
            }
            case 1: {
                return Constraint.merge("subPath", this.arithm(start, "=", offset), this.arithm(end, "=", offset), this.arithm(vars[0], "=", 1 + offset), this.arithm(SIZE, "=", 1));
            }
        }
        return Constraint.merge("subPath", this.arithm(start, "<", vars.length + offset), this.subCircuit(ArrayUtils.concat(vars, start), offset, end.getModel().intOffsetView(SIZE, 1)), this.element(end.getModel().intVar(vars.length + offset), vars, end, offset));
    }

    default public Constraint sum(IntVar[] vars, String operator, int sum) {
        if (!1.$assertionsDisabled && vars.length <= 0) {
            throw new AssertionError();
        }
        Model s = vars[0].getModel();
        IntVar sumVar = s.intVar(sum);
        return IntLinCombFactory.reduce(vars, Operator.get(operator), sumVar);
    }

    default public Constraint sum(IntVar[] vars, String operator, IntVar sum) {
        return IntLinCombFactory.reduce(vars, Operator.get(operator), sum);
    }

    default public Constraint sum(BoolVar[] vars, String operator, int sum) {
        if (!1.$assertionsDisabled && vars.length <= 0) {
            throw new AssertionError();
        }
        Model s = vars[0].getModel();
        IntVar sumVar = s.intVar(sum);
        return this.sum(vars, operator, sumVar);
    }

    default public Constraint sum(BoolVar[] vars, String operator, IntVar sum) {
        if (sum.getModel().getSettings().enableDecompositionOfBooleanSum()) {
            int[] bounds = VariableUtils.boundsForAddition(vars);
            IntVar p = sum.getModel().intVar(sum.getModel().generateName("RSLT_"), bounds[0], bounds[1], true);
            IntLinCombFactory.reduce(vars, Operator.EQ, p).post();
            return this.arithm(p, operator, sum);
        }
        return IntLinCombFactory.reduce(vars, Operator.get(operator), sum);
    }

    default public Constraint table(IntVar[] vars, Tuples tuples) {
        String algo = "GAC3rm";
        if (tuples.isFeasible()) {
            algo = tuples.nbTuples() > 500 ? "CT+" : "GACSTR+";
        }
        return this.table(vars, tuples, algo);
    }

    default public Constraint table(IntVar[] vars, Tuples tuples, String algo) {
        Propagator p;
        if (vars.length == 2) {
            return this.table(vars[0], vars[1], tuples);
        }
        if (algo.contains("+") && !tuples.isFeasible()) {
            throw new SolverException(algo + " table algorithm cannot be used with forbidden tuples.");
        }
        switch (algo) {
            case "CT+": {
                p = new PropCompactTable(vars, tuples);
                break;
            }
            case "MDD+": {
                p = new PropLargeMDDC(new MultivaluedDecisionDiagram(vars, tuples), vars);
                break;
            }
            case "FC": {
                p = new PropLargeFC(vars, tuples);
                break;
            }
            case "GAC3rm": {
                p = new PropLargeGAC3rm(vars, tuples);
                break;
            }
            case "GAC2001": {
                p = new PropLargeGAC2001(vars, tuples);
                break;
            }
            case "GACSTR+": {
                p = new PropLargeGACSTRPos(vars, tuples);
                break;
            }
            case "GAC2001+": {
                p = new PropLargeGAC2001Positive(vars, tuples);
                break;
            }
            case "GAC3rm+": {
                p = new PropLargeGAC3rmPositive(vars, tuples);
                break;
            }
            case "STR2+": {
                p = new PropTableStr2(vars, tuples);
                break;
            }
            default: {
                throw new SolverException("Table algorithm " + algo + " is unkown");
            }
        }
        return new Constraint("Table(" + algo + ")", p);
    }

    default public Constraint tree(IntVar[] succs, IntVar nbTrees) {
        return this.tree(succs, nbTrees, 0);
    }

    default public Constraint tree(IntVar[] succs, IntVar nbTrees, int offset) {
        return new Constraint("tree", new PropAntiArborescences(succs, offset, false), new PropKLoops(succs, offset, nbTrees));
    }

    default public int[] getDomainUnion(IntVar ... vars) {
        int k;
        int m = vars[0].getLB();
        int M = vars[0].getUB();
        for (int i = 1; i < vars.length; ++i) {
            int j;
            k = vars[i].getLB();
            if (m > k) {
                m = k;
            }
            if (M >= (j = vars[i].getUB())) continue;
            M = j;
        }
        BitSet values = new BitSet(M - m + 1);
        for (IntVar v : vars) {
            int lb = v.getLB();
            int i = v.getUB();
            while (i >= lb) {
                values.set(i - m);
                i = v.previousValue(i);
            }
        }
        int[] vs = new int[values.cardinality()];
        k = 0;
        int i = values.nextSetBit(0);
        while (i >= 0) {
            vs[k++] = i + m;
            i = values.nextSetBit(i + 1);
        }
        return vs;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

