/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.ReificationConstraint;
import org.chocosolver.solver.constraints.reification.PropOpposite;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class Constraint {
    protected final Propagator[] propagators;
    private BoolVar boolReif;
    private Constraint opposite;
    private Status mStatus;
    private int cidx;
    private String name;

    public Constraint(String name, Propagator ... propagators) {
        if (propagators == null || propagators.length == 0) {
            throw new UnsupportedOperationException("cannot create a constraint without propagators ");
        }
        this.name = name;
        this.propagators = propagators;
        this.mStatus = Status.FREE;
        this.cidx = -1;
        for (Propagator propagator : propagators) {
            propagator.defineIn(this);
        }
    }

    public Propagator[] getPropagators() {
        return this.propagators;
    }

    public Propagator getPropagator(int i) {
        return this.propagators[i];
    }

    public ESat isSatisfied() {
        int sat = 0;
        for (Propagator propagator : this.propagators) {
            ESat entail = propagator.isEntailed();
            if (entail.equals((Object)ESat.FALSE)) {
                return entail;
            }
            if (!entail.equals((Object)ESat.TRUE)) continue;
            ++sat;
        }
        if (sat == this.propagators.length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    public String toString() {
        return this.name + " (" + Arrays.toString(this.propagators) + ")";
    }

    public final boolean isReified() {
        return this.boolReif != null;
    }

    public final void reifyWith(BoolVar bool) {
        Model s = this.propagators[0].getModel();
        if (this.opposite == null) {
            this.opposite = this.makeOpposite();
            this.opposite.opposite = this;
        }
        if (this.boolReif == null) {
            this.boolReif = bool;
            assert (this.opposite.boolReif == null);
            this.opposite.boolReif = this.boolReif.not();
            if (this.boolReif.isInstantiatedTo(1)) {
                this.post();
            } else if (this.boolReif.isInstantiatedTo(0)) {
                this.opposite.post();
            } else {
                new ReificationConstraint(this.boolReif, this, this.opposite).post();
            }
        } else if (bool != this.boolReif) {
            s.arithm((IntVar)bool, "=", this.boolReif).post();
        }
    }

    public final BoolVar reify() {
        if (this.boolReif == null) {
            Model model = this.propagators[0].getModel();
            this.reifyWith(model.boolVar(model.generateName("REIF_")));
        }
        return this.boolReif;
    }

    public final void post() {
        this.propagators[0].getModel().post(this);
    }

    public final void declareAs(Status aStatus, int idx) throws SolverException {
        this.checkNewStatus(aStatus);
        this.mStatus = aStatus;
        this.cidx = idx;
    }

    public final void checkNewStatus(Status aStatus) throws SolverException {
        switch (this.mStatus) {
            default: {
                if (aStatus != Status.FREE) break;
                throw new SolverException("Try to remove a constraint which is not known from the model.");
            }
            case POSTED: {
                switch (aStatus) {
                    case POSTED: {
                        throw new SolverException("Try to post a constraint which is already posted in the model.");
                    }
                    case REIFIED: {
                        throw new SolverException("Try to post a constraint which is already reified in the model.");
                    }
                }
                break;
            }
            case REIFIED: {
                switch (aStatus) {
                    case POSTED: {
                        throw new SolverException("Try to reify a constraint which is already posted in the model.");
                    }
                    case REIFIED: {
                        throw new SolverException("Try to reify a constraint which is already reified in the model.");
                    }
                }
            }
        }
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    public int getCidxInModel() {
        return this.cidx;
    }

    public Constraint getOpposite() {
        if (this.opposite == null) {
            this.opposite = this.makeOpposite();
            this.opposite.opposite = this;
        }
        return this.opposite;
    }

    protected Constraint makeOpposite() {
        Object[] vars;
        if (this.propagators.length == 1) {
            vars = this.propagators[0].vars;
        } else {
            HashSet allvars = new HashSet();
            for (Propagator p : this.propagators) {
                Collections.addAll(allvars, p.vars);
            }
            vars = allvars.toArray(new Variable[allvars.size()]);
        }
        return new Constraint("DefaultOppositeOf" + this.name, new PropOpposite(this, (Variable[])vars));
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public PropagatorPriority computeMaxPriority() {
        int priority = 1;
        for (Propagator p : this.propagators) {
            priority = Math.max(priority, p.getPriority().priority);
        }
        return PropagatorPriority.get(priority);
    }

    public static Constraint merge(String name, Constraint ... toMerge) {
        ArrayList props = new ArrayList();
        for (Constraint c : toMerge) {
            Collections.addAll(props, c.getPropagators());
        }
        return new Constraint(name, props.toArray(new Propagator[props.size()]));
    }

    public static enum Status {
        POSTED,
        REIFIED,
        FREE;

    }
}

