/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.ISolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.cnf.SatConstraint;
import org.chocosolver.solver.constraints.nary.nogood.NogoodConstraint;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.explanations.IExplanationEngine;
import org.chocosolver.solver.explanations.NoExplanationEngine;
import org.chocosolver.solver.objective.IBoundsManager;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.propagation.PropagationEngineFactory;
import org.chocosolver.solver.search.SearchState;
import org.chocosolver.solver.search.limits.ICounter;
import org.chocosolver.solver.search.loop.Reporting;
import org.chocosolver.solver.search.loop.learn.Learn;
import org.chocosolver.solver.search.loop.monitors.ISearchMonitor;
import org.chocosolver.solver.search.loop.monitors.SearchMonitorList;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.loop.move.MoveBinaryDFS;
import org.chocosolver.solver.search.loop.move.MoveSeq;
import org.chocosolver.solver.search.loop.propagate.Propagate;
import org.chocosolver.solver.search.loop.propagate.PropagateBasic;
import org.chocosolver.solver.search.measure.IMeasures;
import org.chocosolver.solver.search.measure.MeasuresRecorder;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.decision.DecisionPath;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.trace.IOutputFactory;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.criteria.Criterion;

public class Solver
implements ISolver,
IMeasures,
IOutputFactory {
    private transient PrintStream out = System.out;
    private transient PrintStream err = System.err;
    private Propagate P;
    private Learn L;
    private Move M;
    private Model mModel;
    private IObjectiveManager objectivemanager;
    private Action action;
    private MeasuresRecorder mMeasures;
    private DecisionPath dpath;
    private int rootWorldIndex = 0;
    private int searchWorldIndex = 0;
    private List<Criterion> criteria;
    private boolean defaultSearch = false;
    private boolean completeSearch = false;
    private IExplanationEngine explainer;
    private SearchMonitorList searchMonitors;
    private IPropagationEngine engine;
    private final ContradictionException exception;
    private ESat feasible = ESat.UNDEFINED;
    private int jumpTo;
    private boolean stop;
    private boolean canBeRepaired = true;

    protected Solver(Model aModel) {
        this.mModel = aModel;
        this.engine = NoPropagationEngine.SINGLETON;
        this.exception = new ContradictionException();
        this.explainer = NoExplanationEngine.SINGLETON;
        this.objectivemanager = ObjectiveFactory.SAT();
        this.dpath = new DecisionPath(aModel.getEnvironment());
        this.action = Action.initialize;
        this.mMeasures = new MeasuresRecorder(this.mModel.getName());
        this.criteria = new ArrayList<Criterion>();
        this.mMeasures.setSearchState(SearchState.NEW);
        this.mMeasures.setBoundsManager(this.objectivemanager);
        this.searchMonitors = new SearchMonitorList();
        this.setMove(new MoveBinaryDFS());
        this.setPropagate(new PropagateBasic());
        this.setNoLearning();
    }

    public void throwsException(ICause c, Variable v, String s) throws ContradictionException {
        throw this.exception.set(c, v, s);
    }

    public ContradictionException getContradictionException() {
        return this.exception;
    }

    public boolean solve() {
        boolean satPb;
        this.mMeasures.setSearchState(SearchState.RUNNING);
        boolean bl = satPb = this.getModel().getResolutionPolicy() == ResolutionPolicy.SATISFACTION;
        if (this.getModel().getObjective() == null && !satPb) {
            throw new SolverException("No objective variable has been defined whereas policy implies optimization");
        }
        boolean bl2 = this.stop = !this.canBeRepaired;
        if (this.action == Action.initialize) {
            this.searchMonitors.beforeInitialize();
            this.initialize();
            this.searchMonitors.afterInitialize();
        }
        boolean newSolutionFound = this.searchLoop();
        this.searchMonitors.beforeClose();
        this.closeSearch();
        this.searchMonitors.afterClose();
        return newSolutionFound;
    }

    private boolean searchLoop() {
        boolean solution = false;
        boolean left = true;
        Thread th = Thread.currentThread();
        block9: while (!this.stop) {
            this.stop = this.isStopCriterionMet();
            if (this.stop || th.isInterrupted()) {
                if (this.stop) {
                    this.mMeasures.setSearchState(SearchState.STOPPED);
                } else {
                    this.mMeasures.setSearchState(SearchState.KILLED);
                }
            }
            switch (this.action) {
                case initialize: {
                    throw new UnsupportedOperationException("should not initialize during search loop");
                }
                case propagate: {
                    this.searchMonitors.beforeDownBranch(left);
                    this.mMeasures.incDepth();
                    try {
                        this.P.execute(this);
                        this.action = Action.extend;
                    }
                    catch (ContradictionException ce) {
                        this.engine.flush();
                        this.mMeasures.incFailCount();
                        this.jumpTo = 1;
                        this.action = Action.repair;
                        this.searchMonitors.onContradiction(ce);
                    }
                    this.searchMonitors.afterDownBranch(left);
                    continue block9;
                }
                case extend: {
                    left = true;
                    this.searchMonitors.beforeOpenNode();
                    this.mMeasures.incNodeCount();
                    this.action = !this.M.extend(this) ? Action.validate : Action.propagate;
                    this.searchMonitors.afterOpenNode();
                    continue block9;
                }
                case repair: {
                    left = false;
                    this.L.record(this);
                    this.searchMonitors.beforeUpBranch();
                    this.action = Action.propagate;
                    this.canBeRepaired = this.M.repair(this);
                    this.searchMonitors.afterUpBranch();
                    if (!this.canBeRepaired) {
                        this.stop = true;
                        continue block9;
                    }
                    this.L.forget(this);
                    continue block9;
                }
                case validate: {
                    if (!this.getModel().getSettings().checkModel(this)) {
                        throw new SolverException("The current solution does not satisfy the checker.\n" + Reporting.fullReport(this.mModel));
                    }
                    this.feasible = ESat.TRUE;
                    this.mMeasures.incSolutionCount();
                    this.objectivemanager.updateBestSolution();
                    this.searchMonitors.onSolution();
                    this.jumpTo = 1;
                    this.action = Action.repair;
                    solution = true;
                    this.stop = true;
                    continue block9;
                }
            }
            throw new SolverException("Invalid Solver loop action " + (Object)((Object)this.action));
        }
        return solution;
    }

    protected void initialize() {
        if (this.mModel.getHook("H_MINISAT") != null) {
            SatConstraint minisat = (SatConstraint)this.mModel.getHook("H_MINISAT");
            minisat.getPropSat().initialize();
        }
        if (this.mModel.getHook("H_NOGOODS") != null) {
            NogoodConstraint nogoods = (NogoodConstraint)this.mModel.getHook("H_NOGOODS");
            nogoods.getPropNogoods().initialize();
        }
        if (this.engine == NoPropagationEngine.SINGLETON) {
            this.setEngine(PropagationEngineFactory.DEFAULT.make(this.mModel));
        }
        this.engine.initialize();
        this.getMeasures().setReadingTimeCount(System.nanoTime() - this.mModel.getCreationTime());
        this.mMeasures.startStopwatch();
        this.rootWorldIndex = this.mModel.getEnvironment().getWorldIndex();
        this.mModel.getEnvironment().buildFakeHistoryOn(this.mModel.getSettings().getEnvironmentHistorySimulationCondition());
        this.M.setTopDecisionPosition(0);
        this.mModel.getEnvironment().worldPush();
        try {
            if (this.mModel.getHook("H_TASKSET") != null) {
                ArrayList tset = (ArrayList)this.mModel.getHook("H_TASKSET");
                for (int i = 0; i < tset.size(); ++i) {
                    ((Task)tset.get(i)).ensureBoundConsistency();
                }
            }
            this.P.execute(this);
            this.action = Action.extend;
            this.mModel.getEnvironment().worldPush();
            this.searchWorldIndex = this.mModel.getEnvironment().getWorldIndex();
            this.mModel.getEnvironment().worldPush();
        }
        catch (ContradictionException ce) {
            this.engine.flush();
            this.mMeasures.incFailCount();
            this.searchMonitors.onContradiction(ce);
            this.L.record(this);
            this.L.forget(this);
            this.mModel.getEnvironment().worldPop();
            this.stop = true;
        }
        if (this.M.getChildMoves().size() <= 1 && this.M.getStrategy() == null) {
            if (this.mModel.getSettings().warnUser()) {
                this.getErr().printf("No search strategies defined.\nSet to default ones.", new Object[0]);
            }
            this.defaultSearch = true;
            this.setSearch(this.mModel.getSettings().makeDefaultSearch(this.mModel));
        }
        if (this.completeSearch && !this.defaultSearch) {
            AbstractStrategy declared = this.M.getStrategy();
            AbstractStrategy complete = this.mModel.getSettings().makeDefaultSearch(this.mModel);
            this.setSearch(declared, complete);
        }
        if (!this.M.init()) {
            this.mModel.getEnvironment().worldPop();
            this.feasible = ESat.FALSE;
            this.engine.flush();
            this.getMeasures().incFailCount();
            this.stop = true;
        }
        this.criteria.stream().filter(c -> c instanceof ICounter).forEach(c -> ((ICounter)c).init());
    }

    private void closeSearch() {
        if (this.mMeasures.getSearchState() == SearchState.RUNNING) {
            this.mMeasures.setSearchState(SearchState.TERMINATED);
        }
        this.feasible = ESat.FALSE;
        if (this.mMeasures.getSolutionCount() > 0L) {
            this.feasible = ESat.TRUE;
            if (this.objectivemanager.isOptimization()) {
                this.mMeasures.setObjectiveOptimal(!this.isStopCriterionMet());
            }
        } else if (this.isStopCriterionMet()) {
            this.mMeasures.setObjectiveOptimal(false);
            this.feasible = ESat.UNDEFINED;
        }
    }

    public void reset() {
        if (this.rootWorldIndex > -1) {
            this.mModel.getEnvironment().worldPopUntil(this.rootWorldIndex);
        }
        this.searchWorldIndex = 0;
        this.action = Action.initialize;
        this.mMeasures.reset();
        this.engine.flush();
        this.dpath.synchronize();
        this.objectivemanager.resetBestBounds();
        this.removeAllStopCriteria();
        this.feasible = ESat.UNDEFINED;
        this.jumpTo = 0;
        this.stop = false;
        this.canBeRepaired = true;
    }

    public void hardReset() {
        this.reset();
        this.setMove(new MoveBinaryDFS());
        this.setPropagate(new PropagateBasic());
        this.setNoLearning();
        this.searchMonitors.reset();
        this.defaultSearch = false;
        this.completeSearch = false;
        this.mModel.removeMinisat();
        this.mModel.removeNogoodStore();
    }

    public void propagate() throws ContradictionException {
        if (this.engine == NoPropagationEngine.SINGLETON) {
            this.setEngine(PropagationEngineFactory.DEFAULT.make(this.mModel));
        }
        if (!this.engine.isInitialized()) {
            this.engine.initialize();
        }
        this.engine.propagate();
    }

    public void restart() {
        this.searchMonitors.beforeRestart();
        this.restoreRootNode();
        this.mModel.getEnvironment().worldPush();
        this.getMeasures().incRestartCount();
        try {
            this.objectivemanager.postDynamicCut();
            this.P.execute(this);
            this.action = Action.extend;
        }
        catch (ContradictionException e) {
            this.stop = true;
        }
        this.searchMonitors.afterRestart();
    }

    public void restoreRootNode() {
        this.mModel.getEnvironment().worldPopUntil(this.searchWorldIndex);
        this.dpath.synchronize();
    }

    public Model getModel() {
        return this.mModel;
    }

    public Learn getLearner() {
        return this.L;
    }

    public Move getMove() {
        return this.M;
    }

    public Propagate getPropagate() {
        return this.P;
    }

    public IEnvironment getEnvironment() {
        return this.getModel().getEnvironment();
    }

    public DecisionPath getDecisionPath() {
        return this.dpath;
    }

    public <V extends Variable> AbstractStrategy<V> getSearch() {
        if (this.M.getChildMoves().size() > 1 && this.mModel.getSettings().warnUser()) {
            this.err.print("This search loop is based on a sequential Move, the strategy returned may not reflect the reality.");
        }
        return this.M.getStrategy();
    }

    public <V extends Variable> IObjectiveManager<V> getObjectiveManager() {
        return this.objectivemanager;
    }

    public boolean isDefaultSearchUsed() {
        return this.defaultSearch;
    }

    public boolean isSearchCompleted() {
        return this.completeSearch;
    }

    public boolean hasEndedUnexpectedly() {
        return this.mMeasures.getSearchState() == SearchState.KILLED;
    }

    public boolean isStopCriterionMet() {
        boolean ismet = false;
        for (int i = 0; i < this.criteria.size() && !ismet; ++i) {
            ismet = this.criteria.get(i).isMet();
        }
        return ismet;
    }

    public int getSearchWorldIndex() {
        return this.searchWorldIndex;
    }

    public MeasuresRecorder getMeasures() {
        return this.mMeasures;
    }

    public IExplanationEngine getExplainer() {
        return this.explainer;
    }

    public IPropagationEngine getEngine() {
        return this.engine;
    }

    public ESat isFeasible() {
        return this.feasible;
    }

    public ESat isSatisfied() {
        if (this.feasible != ESat.FALSE) {
            int OK = 0;
            for (Constraint c : this.mModel.getCstrs()) {
                ESat satC = c.isSatisfied();
                if (ESat.FALSE == satC) {
                    System.err.println(String.format("FAILURE >> %s (%s)", new Object[]{c.toString(), satC}));
                    return ESat.FALSE;
                }
                if (ESat.TRUE != satC) continue;
                ++OK;
            }
            if (OK == this.mModel.getCstrs().length) {
                return ESat.TRUE;
            }
            return ESat.UNDEFINED;
        }
        return ESat.FALSE;
    }

    public int getJumpTo() {
        return this.jumpTo;
    }

    public void setLearner(Learn l) {
        this.L = l;
    }

    public void setMove(Move ... m) {
        this.M = m == null ? null : (m.length == 1 ? m[0] : new MoveSeq(this.getModel(), m));
    }

    public void setPropagate(Propagate p) {
        this.P = p;
    }

    public void setObjectiveManager(IObjectiveManager om) {
        this.objectivemanager = om;
        this.mMeasures.setBoundsManager(om);
    }

    public void setSearch(AbstractStrategy ... strategies) {
        if (strategies == null || strategies.length == 0) {
            throw new UnsupportedOperationException("no search strategy has been specified");
        }
        if (this.M.getChildMoves().size() > 1) {
            throw new UnsupportedOperationException("The Move declared is composed of many Moves.\nA strategy must be attached to each of them independently, and it cannot be achieved calling this method.An iteration over it child moves is needed: this.getMove().getChildMoves().");
        }
        this.M.setStrategy(strategies.length == 1 ? strategies[0] : Search.sequencer(strategies));
    }

    public void setExplainer(IExplanationEngine explainer) {
        this.explainer = explainer;
    }

    public void setEngine(IPropagationEngine propagationEngine) {
        if (this.engine != NoPropagationEngine.SINGLETON && this.engine.isInitialized() && this.getEnvironment().getWorldIndex() != this.rootWorldIndex && propagationEngine != NoPropagationEngine.SINGLETON) {
            throw new SolverException("Illegal propagation engine modification.");
        }
        this.engine = propagationEngine;
    }

    public void makeCompleteStrategy(boolean isComplete) {
        this.completeSearch = isComplete;
    }

    public void addStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            Collections.addAll(this.criteria, criterion);
        }
    }

    public void removeStopCriterion(Criterion ... criterion) {
        if (criterion != null) {
            for (Criterion c : criterion) {
                this.criteria.remove(c);
            }
        }
    }

    public void removeAllStopCriteria() {
        this.criteria.clear();
    }

    public SearchMonitorList getSearchMonitors() {
        return this.searchMonitors;
    }

    public void plugMonitor(ISearchMonitor sm) {
        this.searchMonitors.add(sm);
    }

    public void unplugMonitor(ISearchMonitor sm) {
        this.searchMonitors.remove(sm);
    }

    public void unplugAllSearchMonitors() {
        this.searchMonitors.reset();
    }

    public void setJumpTo(int jto) {
        this.jumpTo = jto;
    }

    @Override
    public Solver _me() {
        return this;
    }

    @Override
    public String getModelName() {
        return this.getMeasures().getModelName();
    }

    @Override
    public long getTimestamp() {
        return this.getMeasures().getTimestamp();
    }

    @Override
    public float getTimeCount() {
        return this.getMeasures().getTimeCount();
    }

    @Override
    public long getTimeCountInNanoSeconds() {
        return this.getMeasures().getTimeCountInNanoSeconds();
    }

    @Override
    public long getReadingTimeCountInNanoSeconds() {
        return this.getMeasures().getReadingTimeCountInNanoSeconds();
    }

    @Override
    public float getReadingTimeCount() {
        return this.getMeasures().getReadingTimeCount();
    }

    @Override
    public long getNodeCount() {
        return this.getMeasures().getNodeCount();
    }

    @Override
    public long getBackTrackCount() {
        return this.getMeasures().getBackTrackCount();
    }

    @Override
    public long getFailCount() {
        return this.getMeasures().getFailCount();
    }

    @Override
    public long getRestartCount() {
        return this.getMeasures().getRestartCount();
    }

    @Override
    public long getSolutionCount() {
        return this.getMeasures().getSolutionCount();
    }

    @Override
    public long getDecisionCount() {
        return this.getMeasures().getDecisionCount();
    }

    @Override
    public long getMaxDepth() {
        return this.getMeasures().getMaxDepth();
    }

    @Override
    public long getCurrentDepth() {
        return this.getMeasures().getCurrentDepth();
    }

    @Override
    public boolean hasObjective() {
        return this.getMeasures().hasObjective();
    }

    @Override
    public boolean isObjectiveOptimal() {
        return this.getMeasures().isObjectiveOptimal();
    }

    @Override
    public Number getBestSolutionValue() {
        return this.getMeasures().getBestSolutionValue();
    }

    @Override
    public SearchState getSearchState() {
        return this.getMeasures().getSearchState();
    }

    @Override
    public IBoundsManager getBoundsManager() {
        assert (this.getMeasures().getBoundsManager() == this.objectivemanager);
        return this.getMeasures().getBoundsManager();
    }

    @Override
    public void setOut(PrintStream printStream) {
        this.out = printStream;
    }

    @Override
    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public void setErr(PrintStream printStream) {
        this.err = printStream;
    }

    @Override
    public PrintStream getErr() {
        return this.out;
    }

    protected static enum Action {
        initialize,
        propagate,
        extend,
        validate,
        repair;

    }
}

