/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import org.chocosolver.memory.Except_0;
import org.chocosolver.memory.ICondition;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.util.ESat;

public interface Settings {
    default public String getWelcomeMessage() {
        return "** Choco 4.0.4 (2017-04) : Constraint Programming Solver, Copyleft (c) 2010-2017";
    }

    default public boolean checkModel(Solver solver) {
        return !ESat.FALSE.equals((Object)solver.isSatisfied());
    }

    default public boolean enableViews() {
        return true;
    }

    default public int getMaxDomSizeForEnumerated() {
        return 32768;
    }

    default public int getMinCardForSumDecomposition() {
        return 100;
    }

    default public boolean enableTableSubstitution() {
        return true;
    }

    default public int getMaxTupleSizeForSubstitution() {
        return 10000;
    }

    default public double getMCRDecimalPrecision() {
        return 1.0E-4;
    }

    default public short[] getFineEventPriority() {
        return new short[]{0, 0, 0, 1, 2, 2, 2};
    }

    default public short[] getCoarseEventPriority() {
        return new short[]{0, 0, 0, 0, 1, 2, 3};
    }

    default public boolean sortPropagatorActivationWRTPriority() {
        return true;
    }

    default public AbstractStrategy makeDefaultSearch(Model model) {
        return Search.defaultSearch(model);
    }

    default public ICondition getEnvironmentHistorySimulationCondition() {
        return new Except_0();
    }

    default public boolean warnUser() {
        return false;
    }

    default public boolean debugPropagation() {
        return false;
    }

    default public boolean enableDecompositionOfBooleanSum() {
        return false;
    }

    default public boolean enableIncrementalityOnBoolSum(int nbvars) {
        return nbvars > 10;
    }

    default public boolean cloneVariableArrayInPropagator() {
        return true;
    }

    default public boolean enableACOnTernarySum() {
        return false;
    }

    default public String defaultPrefix() {
        return "TMP_";
    }

    default public boolean enableSAT() {
        return false;
    }

    default public boolean swapOnPassivate() {
        return false;
    }
}

