/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.limits.FailCounter;
import org.chocosolver.solver.search.loop.lns.INeighborFactory;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class ParallelPortfolio {
    private final List<Model> models;
    private boolean searchAutoConf;
    private boolean isPrepared = false;
    private AtomicBoolean solverTerminated = new AtomicBoolean(false);
    private AtomicBoolean solutionFound = new AtomicBoolean(false);
    private Model finder;

    public ParallelPortfolio(boolean searchAutoConf) {
        this.models = new ArrayList<Model>();
        this.searchAutoConf = searchAutoConf;
    }

    public ParallelPortfolio() {
        this(true);
    }

    public void addModel(Model model) {
        this.models.add(model);
    }

    public boolean solve() {
        this.getSolverTerminated().set(false);
        this.getSolutionFound().set(false);
        if (!this.isPrepared) {
            this.prepare();
        }
        ForkJoinPool forkJoinPool = new ForkJoinPool(this.models.size());
        try {
            ((ForkJoinTask)forkJoinPool.submit(() -> this.models.parallelStream().forEach(m -> {
                boolean so;
                if (!this.getSolverTerminated().get() && ((so = m.getSolver().solve()) && this.finder == m || !so)) {
                    this.getSolverTerminated().set(true);
                }
            }))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        forkJoinPool.shutdownNow();
        this.getSolverTerminated().set(false);
        if (this.getSolutionFound().get() && this.models.get(0).getResolutionPolicy() != ResolutionPolicy.SATISFACTION) {
            int bestAll = this.getBestModel().getSolver().getBestSolutionValue().intValue();
            for (Model m : this.models) {
                int mVal = m.getSolver().getBestSolutionValue().intValue();
                if (m.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                    assert (mVal <= bestAll) : mVal + " > " + bestAll;
                    continue;
                }
                if (m.getResolutionPolicy() == ResolutionPolicy.MINIMIZE) assert (mVal >= bestAll) : mVal + " < " + bestAll;
            }
        }
        return this.getSolutionFound().get();
    }

    public Model getBestModel() {
        return this.finder;
    }

    public List<Model> getModels() {
        return this.models;
    }

    private void prepare() {
        this.isPrepared = true;
        this.check();
        for (int i = 0; i < this.models.size(); ++i) {
            Solver s = this.models.get(i).getSolver();
            s.addStopCriterion(() -> this.getSolverTerminated().get());
            s.plugMonitor(() -> this.updateFromSolution(s.getModel()));
            if (!this.searchAutoConf) continue;
            this.configureModel(i);
        }
    }

    private synchronized void updateFromSolution(Model m) {
        if (m.getResolutionPolicy() == ResolutionPolicy.SATISFACTION) {
            this.finder = m;
            this.getSolutionFound().set(true);
        } else {
            int solverVal = ((IntVar)m.getObjective()).getValue();
            int bestVal = m.getSolver().getObjectiveManager().getBestSolutionValue().intValue();
            if (m.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                assert (solverVal <= bestVal) : solverVal + ">" + bestVal;
            } else if (m.getResolutionPolicy() == ResolutionPolicy.MINIMIZE) assert (solverVal >= bestVal) : solverVal + "<" + bestVal;
            if (solverVal == bestVal) {
                this.getSolutionFound().set(true);
                this.finder = m;
                if (m.getResolutionPolicy() == ResolutionPolicy.MAXIMIZE) {
                    this.models.forEach(s1 -> s1.getSolver().getObjectiveManager().updateBestLB(bestVal));
                } else {
                    this.models.forEach(s1 -> s1.getSolver().getObjectiveManager().updateBestUB(bestVal));
                }
            }
        }
    }

    private void configureModel(int workerID) {
        Variable[] varsX;
        Model worker = this.getModels().get(workerID);
        Solver solver = worker.getSolver();
        ResolutionPolicy policy = worker.getResolutionPolicy();
        boolean customSearch = false;
        if (solver.getSearch() != null && solver.getSearch().getVariables().length > 0) {
            varsX = solver.getSearch().getVariables();
            customSearch = true;
        } else {
            varsX = worker.getVars();
        }
        IntVar[] ivars = new IntVar[varsX.length];
        SetVar[] svars = new SetVar[varsX.length];
        RealVar[] rvars = new RealVar[varsX.length];
        int ki = 0;
        int ks = 0;
        int kr = 0;
        for (Variable aVarsX : varsX) {
            if ((aVarsX.getTypeAndKind() & 8) > 0) {
                ivars[ki++] = (IntVar)aVarsX;
                continue;
            }
            if ((aVarsX.getTypeAndKind() & 0x20) > 0) {
                svars[ks++] = (SetVar)aVarsX;
                continue;
            }
            if ((aVarsX.getTypeAndKind() & 0x40) > 0) {
                rvars[kr++] = (RealVar)aVarsX;
                continue;
            }
            throw new UnsupportedOperationException("unrecognized variable kind " + aVarsX);
        }
        ivars = Arrays.copyOf(ivars, ki);
        svars = Arrays.copyOf(svars, ks);
        rvars = Arrays.copyOf(rvars, kr);
        switch (workerID) {
            case 0: {
                break;
            }
            case 1: {
                if (customSearch && !solver.getSearch().getClass().getSimpleName().contains("LastConflict")) {
                    solver.setSearch(Search.lastConflict(solver.getSearch()));
                    break;
                }
                solver.setSearch(Search.lastConflict(Search.intVarSearch(ivars)));
                solver.setGeometricalRestart(ivars.length * 3, 2.0, new FailCounter(solver.getModel(), 1000L), 1000);
                break;
            }
            case 2: {
                if (customSearch && !solver.getSearch().getClass().getSimpleName().contains("ConflictOrderingSearch")) {
                    solver.setSearch(Search.conflictOrderingSearch(solver.getSearch()));
                    break;
                }
                solver.setSearch(Search.conflictOrderingSearch(Search.intVarSearch(ivars)));
                solver.setGeometricalRestart(ivars.length * 3, 2.0, new FailCounter(solver.getModel(), 1000L), 1000);
                break;
            }
            case 3: {
                if (customSearch) {
                    solver.setSearch(Search.lastConflict(Search.intVarSearch(ivars)));
                    solver.setGeometricalRestart(ivars.length * 3, 2.0, new FailCounter(solver.getModel(), 1000L), 1000);
                } else {
                    solver.setSearch(Search.inputOrderLBSearch(ivars));
                }
                if (policy != ResolutionPolicy.SATISFACTION) {
                    solver.setLNS(INeighborFactory.blackBox(ivars), new FailCounter(solver.getModel(), 1000L));
                    break;
                }
                solver.setNoGoodRecordingFromRestarts();
                break;
            }
            case 4: {
                if (customSearch && !solver.getSearch().getClass().getSimpleName().contains("ConflictOrderingSearch")) {
                    solver.setLDS(Integer.MAX_VALUE);
                    solver.setSearch(Search.conflictOrderingSearch(solver.getSearch()));
                    break;
                }
                solver.setLDS(Integer.MAX_VALUE);
                solver.setSearch(Search.conflictOrderingSearch(Search.intVarSearch(ivars)));
                solver.setGeometricalRestart(ivars.length * 3, 2.0, new FailCounter(solver.getModel(), 1000L), 1000);
                break;
            }
            case 5: {
                if (customSearch && !solver.getSearch().getClass().getSimpleName().contains("LastConflict")) {
                    solver.setCBJLearning(false, false);
                    solver.setSearch(Search.lastConflict(solver.getSearch()));
                    break;
                }
                solver.setCBJLearning(false, false);
                solver.setSearch(Search.lastConflict(Search.intVarSearch(ivars)));
                solver.setGeometricalRestart(ivars.length * 3, 2.0, new FailCounter(solver.getModel(), 1000L), 1000);
                break;
            }
            default: {
                solver.setSearch(Search.lastConflict(Search.randomSearch(ivars, workerID)));
                if (policy == ResolutionPolicy.SATISFACTION) break;
                solver.setLNS(INeighborFactory.blackBox(ivars), new FailCounter(solver.getModel(), 1000L));
            }
        }
        if (ks > 0) {
            solver.setSearch(solver.getSearch(), Search.setVarSearch(svars));
        }
        if (kr > 0) {
            solver.setSearch(solver.getSearch(), Search.realVarSearch(rvars));
        }
    }

    private void check() {
        if (this.models.size() == 0) {
            throw new SolverException("No model found in the ParallelPortfolio.");
        }
        if (this.models.get(0).getResolutionPolicy() != ResolutionPolicy.SATISFACTION) {
            Variable objective = this.models.get(0).getObjective();
            if (objective == null) {
                throw new UnsupportedOperationException("No objective has been defined");
            }
            if ((objective.getTypeAndKind() & 0x40) != 0) {
                throw new UnsupportedOperationException("ParallelPortfolio cannot deal with real variable objective optimization problems");
            }
        }
    }

    private synchronized AtomicBoolean getSolverTerminated() {
        return this.solverTerminated;
    }

    private synchronized AtomicBoolean getSolutionFound() {
        return this.solutionFound;
    }
}

