/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.chocosolver.memory.EnvironmentBuilder;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.IModel;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.cnf.PropFalse;
import org.chocosolver.solver.constraints.nary.cnf.PropTrue;
import org.chocosolver.solver.constraints.nary.cnf.SatConstraint;
import org.chocosolver.solver.constraints.nary.nogood.NogoodConstraint;
import org.chocosolver.solver.constraints.real.Ibex;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.objective.ObjectiveFactory;
import org.chocosolver.solver.propagation.IPropagationEngine;
import org.chocosolver.solver.propagation.NoPropagationEngine;
import org.chocosolver.solver.propagation.PropagationTrigger;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;

public class Model
implements IModel {
    public static boolean MAXIMIZE = true;
    public static boolean MINIMIZE = false;
    public static final String TASK_SET_HOOK_NAME = "H_TASKSET";
    public static final String MINISAT_HOOK_NAME = "H_MINISAT";
    public static final String NOGOODS_HOOK_NAME = "H_NOGOODS";
    private Settings settings = new Settings(){};
    private TIntObjectHashMap<IntVar> cachedConstants;
    private Variable[] vars;
    private int vIdx;
    private int nbIntVar;
    private int nbBoolVar;
    private int nbSetVar;
    private int nbRealVar;
    private Constraint[] cstrs;
    private int cIdx;
    private final IEnvironment environment;
    private final Solver solver;
    private Variable objective;
    private double precision = 1.0E-4;
    private String name;
    private long creationTime;
    private int id = 1;
    private int nameId = 1;
    private Ibex ibex;
    private Map<String, Object> hooks;
    private ResolutionPolicy policy = ResolutionPolicy.SATISFACTION;
    private static int modelInitNumber;

    public Model(IEnvironment environment, String name) {
        this.name = name;
        this.vars = new Variable[32];
        this.vIdx = 0;
        this.cstrs = new Constraint[32];
        this.cIdx = 0;
        this.environment = environment;
        this.creationTime = System.nanoTime();
        this.cachedConstants = new TIntObjectHashMap(16, 1.5f, Integer.MAX_VALUE);
        this.objective = null;
        this.hooks = new HashMap<String, Object>();
        this.solver = new Solver(this);
    }

    public Model(String name) {
        this(new EnvironmentBuilder().fromFlat().build(), name);
    }

    public Model() {
        this("Model-" + Model.nextModelNum());
    }

    private static synchronized int nextModelNum() {
        return modelInitNumber++;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public ResolutionPolicy getResolutionPolicy() {
        return this.policy;
    }

    public TIntObjectHashMap<IntVar> getCachedConstants() {
        return this.cachedConstants;
    }

    public Constraint trueConstraint() {
        return new Constraint("TRUE cstr", new PropTrue(this.boolVar(true)));
    }

    public Constraint falseConstraint() {
        return new Constraint("FALSE cstr", new PropFalse(this.boolVar(false)));
    }

    public Solver getSolver() {
        return this.solver;
    }

    public Variable[] getVars() {
        return Arrays.copyOf(this.vars, this.vIdx);
    }

    public int getNbVars() {
        return this.vIdx;
    }

    public Variable getVar(int i) {
        return this.vars[i];
    }

    public int getNbIntVar(boolean includeBoolVar) {
        return this.nbIntVar + (includeBoolVar ? this.nbBoolVar : 0);
    }

    public IntVar[] retrieveIntVars(boolean includeBoolVar) {
        int size = this.getNbIntVar(includeBoolVar);
        IntVar[] ivars = new IntVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            int kind = this.vars[i].getTypeAndKind() & 0x3F8;
            if (kind != 8 && (!includeBoolVar || kind != 24)) continue;
            ivars[k++] = (IntVar)this.vars[i];
        }
        assert (k == size);
        return ivars;
    }

    public int getNbBoolVar() {
        return this.nbBoolVar;
    }

    public BoolVar[] retrieveBoolVars() {
        int size = this.getNbBoolVar();
        BoolVar[] bvars = new BoolVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 24) continue;
            bvars[k++] = (BoolVar)this.vars[i];
        }
        assert (k == size);
        return bvars;
    }

    public int getNbSetVar() {
        return this.nbSetVar;
    }

    public SetVar[] retrieveSetVars() {
        int size = this.getNbSetVar();
        SetVar[] svars = new SetVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 32) continue;
            svars[k++] = (SetVar)this.vars[i];
        }
        assert (k == size);
        return svars;
    }

    public int getNbRealVar() {
        return this.nbRealVar;
    }

    public RealVar[] retrieveRealVars() {
        int size = this.getNbRealVar();
        RealVar[] rvars = new RealVar[size];
        int k = 0;
        for (int i = 0; i < this.vIdx; ++i) {
            if ((this.vars[i].getTypeAndKind() & 0x3F8) != 64) continue;
            rvars[k++] = (RealVar)this.vars[i];
        }
        assert (k == size);
        return rvars;
    }

    public Constraint[] getCstrs() {
        return Arrays.copyOf(this.cstrs, this.cIdx);
    }

    public int getNbCstrs() {
        return this.cIdx;
    }

    public String getName() {
        return this.name;
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public Variable getObjective() {
        return this.objective;
    }

    public double getPrecision() {
        return this.precision;
    }

    public Object getHook(String hookName) {
        return this.hooks.get(hookName);
    }

    protected Map<String, Object> getHooks() {
        return this.hooks;
    }

    public SatConstraint getMinisat() {
        if (this.getHook(MINISAT_HOOK_NAME) == null) {
            SatConstraint minisat = new SatConstraint(this);
            minisat.post();
            this.addHook(MINISAT_HOOK_NAME, minisat);
        }
        return (SatConstraint)this.getHook(MINISAT_HOOK_NAME);
    }

    public void removeMinisat() {
        if (this.getHook(MINISAT_HOOK_NAME) != null) {
            SatConstraint minisat = (SatConstraint)this.getHook(MINISAT_HOOK_NAME);
            this.unpost(minisat);
            this.removeHook(MINISAT_HOOK_NAME);
        }
    }

    public NogoodConstraint getNogoodStore() {
        if (this.getHook(NOGOODS_HOOK_NAME) == null) {
            NogoodConstraint nogoods = new NogoodConstraint(this);
            nogoods.post();
            this.addHook(NOGOODS_HOOK_NAME, nogoods);
        }
        return (NogoodConstraint)this.getHook(NOGOODS_HOOK_NAME);
    }

    public void removeNogoodStore() {
        if (this.getHook(NOGOODS_HOOK_NAME) != null) {
            NogoodConstraint nogoods = (NogoodConstraint)this.getHook(NOGOODS_HOOK_NAME);
            this.unpost(nogoods);
            this.removeHook(NOGOODS_HOOK_NAME);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setObjective(boolean maximize, Variable objective) {
        if (objective == null) {
            throw new SolverException("Cannot set objective to null");
        }
        this.policy = maximize ? ResolutionPolicy.MAXIMIZE : ResolutionPolicy.MINIMIZE;
        this.objective = objective;
        if ((objective.getTypeAndKind() & 0x3F8) == 64) {
            this.getSolver().setObjectiveManager(ObjectiveFactory.makeObjectiveManager((RealVar)objective, this.policy, this.precision));
        } else {
            this.getSolver().setObjectiveManager(ObjectiveFactory.makeObjectiveManager((IntVar)objective, this.policy));
        }
    }

    public void clearObjective() {
        this.objective = null;
        this.policy = ResolutionPolicy.SATISFACTION;
        this.getSolver().setObjectiveManager(ObjectiveFactory.SAT());
    }

    public void setPrecision(double p) {
        this.precision = p;
    }

    public void set(Settings defaults) {
        this.settings = defaults;
    }

    public void addHook(String hookName, Object hookObject) {
        this.hooks.put(hookName, hookObject);
    }

    public void removeHook(String hookName) {
        this.hooks.remove(hookName);
    }

    public void removeAllHooks() {
        this.hooks.clear();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void associates(Variable variable) {
        if (this.vIdx == this.vars.length) {
            Variable[] tmp = this.vars;
            this.vars = new Variable[tmp.length * 2];
            System.arraycopy(tmp, 0, this.vars, 0, this.vIdx);
        }
        this.vars[this.vIdx++] = variable;
        switch (variable.getTypeAndKind() & 0x3F8) {
            case 8: {
                ++this.nbIntVar;
                break;
            }
            case 24: {
                ++this.nbBoolVar;
                break;
            }
            case 32: {
                ++this.nbSetVar;
                break;
            }
            case 64: {
                ++this.nbRealVar;
            }
        }
    }

    public void unassociates(Variable variable) {
        int idx;
        if (variable.getNbProps() > 0) {
            throw new SolverException("Try to remove a variable (" + variable.getName() + ")which is still involved in at least one constraint");
        }
        for (idx = 0; idx < this.vIdx && variable != this.vars[idx]; ++idx) {
        }
        System.arraycopy(this.vars, idx + 1, this.vars, idx + 1 - 1, this.vIdx - (idx + 1));
        this.vars[--this.vIdx] = null;
        switch (variable.getTypeAndKind() & 0x3F8) {
            case 8: {
                --this.nbIntVar;
                break;
            }
            case 24: {
                --this.nbBoolVar;
                break;
            }
            case 32: {
                --this.nbSetVar;
                break;
            }
            case 64: {
                --this.nbRealVar;
            }
        }
    }

    public int nextId() {
        return this.id++;
    }

    public int nextNameId() {
        return this.nameId++;
    }

    public void post(Constraint ... cs) throws SolverException {
        this._post(true, cs);
    }

    private void _post(boolean permanent, Constraint ... cs) throws SolverException {
        boolean dynAdd = false;
        IPropagationEngine engine = this.getSolver().getEngine();
        if (engine != NoPropagationEngine.SINGLETON && engine.isInitialized()) {
            dynAdd = true;
        }
        if (this.cIdx + cs.length >= this.cstrs.length) {
            int nsize;
            for (nsize = this.cstrs.length; this.cIdx + cs.length >= nsize; nsize *= 2) {
            }
            Constraint[] tmp = this.cstrs;
            this.cstrs = new Constraint[nsize];
            System.arraycopy(tmp, 0, this.cstrs, 0, this.cIdx);
        }
        for (Constraint c : cs) {
            for (Propagator p : c.getPropagators()) {
                p.getConstraint().checkNewStatus(Constraint.Status.POSTED);
                p.linkVariables();
            }
            if (dynAdd) {
                engine.dynamicAddition(permanent, c.getPropagators());
            }
            c.declareAs(Constraint.Status.POSTED, this.cIdx);
            this.cstrs[this.cIdx++] = c;
        }
    }

    public void postTemp(Constraint ... cs) throws ContradictionException {
        for (Constraint c : cs) {
            this._post(false, c);
            if (this.getSolver().getEngine() == NoPropagationEngine.SINGLETON || !this.getSolver().getEngine().isInitialized()) {
                throw new SolverException("Try to post a temporary constraint while the resolution has not begun.\nA call to Model.post(Constraint) is more appropriate.");
            }
            for (Propagator propagator : c.getPropagators()) {
                if (this.settings.debugPropagation()) {
                    IPropagationEngine.Trace.printFirstPropagation(propagator);
                }
                PropagationTrigger.execute(propagator, this.getSolver().getEngine());
            }
        }
    }

    public void unpost(Constraint ... constraints) throws SolverException {
        if (constraints != null) {
            for (Constraint c : constraints) {
                int idx = c.getCidxInModel();
                c.declareAs(Constraint.Status.FREE, -1);
                Constraint cm = this.cstrs[--this.cIdx];
                if (idx < this.cIdx) {
                    this.cstrs[idx] = cm;
                    this.cstrs[idx].declareAs(Constraint.Status.FREE, -1);
                    this.cstrs[idx].declareAs(Constraint.Status.POSTED, idx);
                }
                this.cstrs[this.cIdx] = null;
                IPropagationEngine engine = this.getSolver().getEngine();
                if (engine != NoPropagationEngine.SINGLETON && engine.isInitialized()) {
                    engine.dynamicDeletion(c.getPropagators());
                }
                for (Propagator prop : c.getPropagators()) {
                    prop.unlinkVariables();
                }
            }
        }
    }

    public String toString() {
        StringBuilder st = new StringBuilder(256);
        st.append(String.format("\n Model[%s]\n", this.name));
        st.append(String.format("\n[ %d vars -- %d cstrs ]\n", this.vIdx, this.cIdx));
        st.append(String.format("Feasability: %s\n", new Object[]{this.getSolver().isFeasible()}));
        st.append("== variables ==\n");
        for (int v = 0; v < this.vIdx; ++v) {
            st.append(this.vars[v].toString()).append('\n');
        }
        st.append("== constraints ==\n");
        for (int c = 0; c < this.cIdx; ++c) {
            st.append(this.cstrs[c].toString()).append('\n');
        }
        return st.toString();
    }

    public Ibex getIbex() {
        if (this.ibex == null) {
            try {
                this.ibex = new Ibex();
            }
            catch (ExceptionInInitializerError ini) {
                throw new SolverException("Choco cannot initialize Ibex.\nThe following option should be passed as VM argument: \"-Djava.library.path=/path/to/ibex/dynlib\"");
            }
        }
        return this.ibex;
    }

    @Override
    public Model _me() {
        return this;
    }
}

