/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.SatSolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropSat
extends Propagator<BoolVar> {
    private SatSolver sat_;
    private TObjectIntHashMap<BoolVar> indices_;
    private IStateInt sat_trail_;
    private TIntList early_deductions_;
    private TIntObjectHashMap<ArrayList<SatSolver.Clause>> inClauses;
    private ArrayList<BoolVar> add_var;
    private boolean initialized = false;

    public PropSat(Model model) {
        super((Variable[])new BoolVar[]{model.boolVar(true)}, PropagatorPriority.VERY_SLOW, true);
        this.vars = new BoolVar[0];
        this.indices_ = new TObjectIntHashMap(16, 0.5f, -1);
        this.sat_ = new SatSolver();
        this.early_deductions_ = new TIntArrayList();
        this.sat_trail_ = model.getEnvironment().makeInt();
        this.add_var = new ArrayList(16);
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        assert (this.initialized) : "PropSat is not initialized";
        if (!this.sat_.ok_) {
            this.fails();
        }
        this.sat_.cancelUntil(0);
        this.storeEarlyDeductions();
        this.applyEarlyDeductions();
        for (int i = 0; i < ((BoolVar[])this.vars).length; ++i) {
            BoolVar var = ((BoolVar[])this.vars)[i];
            if (!var.isInstantiated()) continue;
            this.VariableBound(i);
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.VariableBound(idxVarInProp);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            for (int k : this.sat_.implies_.keys()) {
                boolean sign = SatSolver.sign(SatSolver.negated(k));
                int var = SatSolver.var(k);
                int val = ((BoolVar[])this.vars)[var].getValue();
                if (val != (sign ? 0 : 1)) continue;
                TIntList lits = this.sat_.implies_.get(k);
                for (int l : lits.toArray()) {
                    sign = SatSolver.sign(l);
                    var = SatSolver.var(l);
                    val = ((BoolVar[])this.vars)[var].getValue();
                    if (val != (sign ? 0 : 1)) continue;
                    return ESat.FALSE;
                }
            }
            boolean OK = this.clauseEntailed(this.sat_.clauses);
            return ESat.eval(OK &= this.clauseEntailed(this.sat_.learnts));
        }
        return ESat.UNDEFINED;
    }

    private boolean clauseEntailed(ArrayList<SatSolver.Clause> clauses) {
        for (SatSolver.Clause c : clauses) {
            int cnt = 0;
            for (int i = 0; i < c.size(); ++i) {
                int lit = c._g(i);
                boolean sign = SatSolver.sign(lit);
                int var = SatSolver.var(lit);
                int val = ((BoolVar[])this.vars)[var].getValue();
                if (val != (sign ? 0 : 1)) break;
                ++cnt;
            }
            if (cnt != c.size()) continue;
            return false;
        }
        return true;
    }

    public SatSolver getSatSolver() {
        return this.sat_;
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.add_var.size() > 0) {
                this.addVariable(this.add_var.toArray(new BoolVar[this.add_var.size()]));
            }
            this.add_var.clear();
            this.initialized = true;
        }
    }

    public int makeVar(BoolVar expr) {
        int var = this.indices_.get(expr);
        if (var == -1) {
            var = this.sat_.newVariable();
            assert (((BoolVar[])this.vars).length + this.add_var.size() == var);
            if (this.initialized) {
                this.addVariable(new BoolVar[]{expr});
            } else {
                this.add_var.add(expr);
            }
            this.indices_.put(expr, var);
        }
        return var;
    }

    public int makeLiteral(BoolVar expr, boolean sign) {
        return SatSolver.makeLiteral(this.makeVar(expr), sign);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void VariableBound(int index) throws ContradictionException {
        try {
            if (this.sat_trail_.get() < this.sat_.trailMarker()) {
                this.sat_.cancelUntil(this.sat_trail_.get());
                assert (this.sat_trail_.get() == this.sat_.trailMarker());
            }
            int var = index;
            boolean sign = ((BoolVar[])this.vars)[index].getValue() != 0;
            int lit = SatSolver.makeLiteral(var, sign);
            boolean fail = !this.sat_.propagateOneLiteral(lit);
            this.sat_trail_.set(this.sat_.trailMarker());
            for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
                lit = this.sat_.touched_variables_.get(i);
                var = SatSolver.var(lit);
                boolean assigned_bool = SatSolver.sign(lit);
                ((BoolVar[])this.vars)[var].instantiateTo(assigned_bool ? 1 : 0, this);
            }
            if (fail) {
                ((BoolVar[])this.vars)[index].instantiateTo(1 - ((BoolVar[])this.vars)[index].getValue(), this);
            }
        }
        finally {
            this.sat_.touched_variables_.resetQuick();
        }
    }

    public void beforeAddingClauses() {
        if (this.sat_trail_.get() < this.sat_.trailMarker()) {
            this.sat_.cancelUntil(this.sat_trail_.get());
            assert (this.sat_trail_.get() == this.sat_.trailMarker());
        }
    }

    public void afterAddingClauses() {
        this.storeEarlyDeductions();
    }

    public boolean addClause(TIntList lits) {
        boolean result = this.sat_.addClause(lits);
        this.storeEarlyDeductions();
        return result;
    }

    public void addLearnt(int ... lits) {
        this.sat_.learnClause(lits);
        this.forcePropagationOnBacktrack();
    }

    private void storeEarlyDeductions() {
        for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
            int lit = this.sat_.touched_variables_.get(i);
            this.early_deductions_.add(lit);
        }
        this.sat_.touched_variables_.resetQuick();
    }

    private void applyEarlyDeductions() throws ContradictionException {
        for (int i = 0; i < this.early_deductions_.size(); ++i) {
            int lit = this.early_deductions_.get(i);
            int var = SatSolver.var(lit);
            boolean assigned_bool = SatSolver.sign(lit);
            ((BoolVar[])this.vars)[var].instantiateTo(assigned_bool ? 1 : 0, this);
        }
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar bvar, IEventType evt, int bvalue) {
        int i;
        ArrayList<SatSolver.Clause> mClauses;
        int i2;
        if (this.inClauses == null) {
            this.fillInClauses();
        }
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        int var = this.indices_.get(bvar);
        boolean new_value = bvar.getValue() != 0;
        int lit = SatSolver.makeLiteral(var, new_value);
        int neg = SatSolver.negated(lit);
        TIntList implies = this.sat_.implies_.get(lit);
        if (implies != null) {
            for (i2 = implies.size() - 1; i2 >= 0; --i2) {
                newrules |= this._why(implies.get(i2), ruleStore);
            }
        }
        if ((implies = (TIntList)this.sat_.implies_.get(neg)) != null) {
            for (i2 = implies.size() - 1; i2 >= 0; --i2) {
                newrules |= this._why(implies.get(i2), ruleStore);
            }
        }
        if ((mClauses = this.inClauses.get(lit)) != null) {
            for (i = mClauses.size() - 1; i >= 0; --i) {
                newrules |= this._why(mClauses.get(i), ruleStore);
            }
        }
        if ((mClauses = this.inClauses.get(neg)) != null) {
            for (i = mClauses.size() - 1; i >= 0; --i) {
                newrules |= this._why(mClauses.get(i), ruleStore);
            }
        }
        for (int k = this.sat_.nLearnt() - 1; k >= 0; --k) {
            newrules |= this._why(neg, lit, this.sat_.learnts.get(k), ruleStore);
        }
        return newrules;
    }

    private void fillInClauses() {
        this.inClauses = new TIntObjectHashMap();
        for (int k = this.sat_.nClauses() - 1; k >= 0; --k) {
            SatSolver.Clause cl = this.sat_.clauses.get(k);
            for (int d = cl.size() - 1; d >= 0; --d) {
                int l = cl._g(d);
                ArrayList<SatSolver.Clause> mcls = this.inClauses.get(l);
                if (mcls == null) {
                    mcls = new ArrayList();
                    this.inClauses.put(l, mcls);
                }
                mcls.add(cl);
            }
        }
    }

    private boolean _why(SatSolver.Clause cl, RuleStore ruleStore) {
        boolean newrules = false;
        if (((BoolVar[])this.vars)[SatSolver.var(cl._g(0))].isInstantiated() && ((BoolVar[])this.vars)[SatSolver.var(cl._g(1))].isInstantiated()) {
            for (int d = cl.size() - 1; d >= 0; --d) {
                newrules |= this._why(cl._g(d), ruleStore);
            }
        }
        return newrules;
    }

    private boolean _why(int neg, int lit, SatSolver.Clause cl, RuleStore ruleStore) {
        boolean newrules;
        block4: {
            block3: {
                newrules = false;
                if (cl._g(0) != neg && cl._g(0) != lit && cl._g(1) != neg && cl._g(1) != lit) break block3;
                for (int d = cl.size() - 1; d >= 0; --d) {
                    newrules |= this._why(cl._g(d), ruleStore);
                }
                break block4;
            }
            if (!((BoolVar[])this.vars)[SatSolver.var(cl._g(0))].isInstantiated() || !((BoolVar[])this.vars)[SatSolver.var(cl._g(1))].isInstantiated()) break block4;
            int p = cl.pos(neg);
            int q = cl.pos(lit);
            if (p > -1 || q > -1) {
                for (int d = cl.size() - 1; d >= 0; --d) {
                    newrules |= this._why(cl._g(d), ruleStore);
                }
            }
        }
        return newrules;
    }

    private boolean _why(int l, RuleStore ruleStore) {
        return ((BoolVar[])this.vars)[SatSolver.var(l)].isInstantiated() && ruleStore.addFullDomainRule(((BoolVar[])this.vars)[SatSolver.var(l)]);
    }
}

