/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.SatSolver;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.explanations.RuleStore;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.util.ESat;

public class PropNogoods
extends Propagator<IntVar> {
    private static final int NO_ENTRY = Integer.MAX_VALUE;
    private static final long BITOP = 0x100000000L;
    private SatSolver sat_;
    private TLongIntHashMap[] vv2lit;
    private int[] var2pos;
    private int[] lit2pos;
    private long[] lit2val;
    private IStateInt sat_trail_;
    private TIntList early_deductions_;
    private BitSet test_eq;
    private Deque<IntVar> fp;
    private TIntObjectHashMap<ArrayList<SatSolver.Clause>> inClauses;
    private ArrayList<IntVar> add_var;
    private boolean initialized = false;

    public PropNogoods(Model model) {
        super((Variable[])new BoolVar[]{model.boolVar(true)}, PropagatorPriority.VERY_SLOW, true);
        this.vars = new IntVar[0];
        int k = 16;
        this.vv2lit = new TLongIntHashMap[k];
        this.lit2val = new long[k];
        Arrays.fill(this.lit2val, Integer.MAX_VALUE);
        this.lit2pos = new int[k];
        Arrays.fill(this.lit2pos, Integer.MAX_VALUE);
        this.var2pos = new int[k];
        Arrays.fill(this.var2pos, Integer.MAX_VALUE);
        this.sat_ = new SatSolver();
        this.early_deductions_ = new TIntArrayList();
        this.sat_trail_ = model.getEnvironment().makeInt();
        this.test_eq = new BitSet();
        this.fp = new ArrayDeque<IntVar>();
        this.add_var = new ArrayList(16);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        assert (this.initialized) : "PropNogoods is not initialized";
        if (!this.sat_.ok_) {
            this.fails();
        }
        this.fp.clear();
        this.sat_.cancelUntil(0);
        this.storeEarlyDeductions();
        this.applyEarlyDeductions();
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            this.doVariableBound(((IntVar[])this.vars)[i]);
        }
        while (this.fp.size() > 0) {
            this.doVariableBound(this.fp.pollFirst());
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.fp.clear();
        this.doVariableBound(((IntVar[])this.vars)[idxVarInProp]);
        while (this.fp.size() > 0) {
            this.doVariableBound(this.fp.pollFirst());
        }
    }

    private void doVariableBound(IntVar var) throws ContradictionException {
        TLongIntHashMap map = this.vv2lit[var.getId()];
        for (long k : map.keys()) {
            int value = PropNogoods.ivalue(k);
            if (PropNogoods.iseq(k)) {
                if (var.contains(value)) {
                    if (!var.isInstantiated()) continue;
                    this.VariableBound(map.get(k), true);
                    continue;
                }
                this.VariableBound(map.get(k), false);
                continue;
            }
            if (var.getUB() <= value) {
                this.VariableBound(map.get(k), true);
                continue;
            }
            if (var.getLB() <= value) continue;
            this.VariableBound(map.get(k), false);
        }
    }

    @Override
    public ESat isEntailed() {
        if (((IntVar[])this.vars).length == 0) {
            return ESat.TRUE;
        }
        if (this.isCompletelyInstantiated()) {
            boolean OK = true;
            for (int k : this.sat_.implies_.keys()) {
                boolean sign = SatSolver.sign(SatSolver.negated(k));
                int var = SatSolver.var(k);
                IntVar ivar = ((IntVar[])this.vars)[this.lit2pos[var]];
                long value = this.lit2val[var];
                boolean eq = PropNogoods.iseq(value);
                int val = PropNogoods.ivalue(value);
                if ((!eq || sign == ivar.contains(val)) && (eq || sign == ivar.getUB() <= val)) continue;
                OK &= this.impliesEntailed(this.sat_.implies_.get(k));
            }
            OK &= this.clauseEntailed(this.sat_.clauses);
            return ESat.eval(OK &= this.clauseEntailed(this.sat_.learnts));
        }
        return ESat.UNDEFINED;
    }

    private boolean impliesEntailed(TIntList lits) {
        for (int l : lits.toArray()) {
            boolean sign = SatSolver.sign(l);
            int var = SatSolver.var(l);
            IntVar ivar = ((IntVar[])this.vars)[this.lit2pos[var]];
            long value = this.lit2val[var];
            if (PropNogoods.iseq(value)) {
                if (sign == ivar.contains(PropNogoods.ivalue(value))) continue;
                return false;
            }
            if (sign && ivar.getLB() > PropNogoods.ivalue(value)) {
                return false;
            }
            if (sign || ivar.getUB() > PropNogoods.ivalue(value)) continue;
            return false;
        }
        return true;
    }

    private boolean clauseEntailed(ArrayList<SatSolver.Clause> clauses) {
        for (SatSolver.Clause c : clauses) {
            int cnt = 0;
            for (int i = 0; i < c.size(); ++i) {
                int lit = c._g(i);
                boolean sign = SatSolver.sign(lit);
                int var = SatSolver.var(lit);
                IntVar ivar = ((IntVar[])this.vars)[this.lit2pos[var]];
                long value = this.lit2val[var];
                if (PropNogoods.iseq(value)) {
                    if (sign == ivar.contains(PropNogoods.ivalue(value))) break;
                    ++cnt;
                    continue;
                }
                if (sign && ivar.getLB() > PropNogoods.ivalue(value)) {
                    ++cnt;
                    continue;
                }
                if (sign || ivar.getUB() > PropNogoods.ivalue(value)) break;
                ++cnt;
            }
            if (cnt != c.size()) continue;
            return false;
        }
        return true;
    }

    private static boolean iseq(long v) {
        return (v & 0x100000000L) == 0L;
    }

    protected static long leq(int v) {
        return (long)v ^ 0x100000000L;
    }

    protected static int ivalue(long v) {
        return (int)(v & 0xFFFFFFFEFFFFFFFFL);
    }

    public void initialize() {
        if (!this.initialized) {
            if (this.add_var.size() > 0) {
                this.addVariable(this.add_var.toArray(new IntVar[this.add_var.size()]));
            }
            this.add_var.clear();
            this.initialized = true;
        }
    }

    public int Literal(IntVar ivar, int value, boolean eq) {
        long lvalue;
        int var;
        int pos;
        TLongIntHashMap map;
        int vid = ivar.getId();
        if (vid >= this.vv2lit.length) {
            TLongIntHashMap[] tmp = this.vv2lit;
            this.vv2lit = new TLongIntHashMap[vid + 1];
            System.arraycopy(tmp, 0, this.vv2lit, 0, tmp.length);
            int[] tmpi = this.var2pos;
            this.var2pos = new int[vid + 1];
            System.arraycopy(tmpi, 0, this.var2pos, 0, tmpi.length);
            Arrays.fill(this.var2pos, tmpi.length, vid + 1, Integer.MAX_VALUE);
        }
        if ((map = this.vv2lit[vid]) == null) {
            this.vv2lit[vid] = map = new TLongIntHashMap(16, 0.5f, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if ((pos = this.var2pos[vid]) == Integer.MAX_VALUE) {
            if (this.initialized) {
                this.addVariable(new IntVar[]{ivar});
                pos = ((IntVar[])this.vars).length - 1;
            } else {
                this.add_var.add(ivar);
                pos = this.add_var.size() - 1;
            }
            this.var2pos[vid] = pos;
        }
        if ((var = map.get(lvalue = eq ? (long)value : PropNogoods.leq(value))) == Integer.MAX_VALUE) {
            var = this.sat_.newVariable();
            map.put(lvalue, var);
            if (var >= this.lit2pos.length) {
                int[] itmp = this.lit2pos;
                this.lit2pos = new int[var + 1];
                System.arraycopy(itmp, 0, this.lit2pos, 0, itmp.length);
                Arrays.fill(this.lit2pos, itmp.length, var + 1, Integer.MAX_VALUE);
                long[] ltmp = this.lit2val;
                this.lit2val = new long[var + 1];
                System.arraycopy(ltmp, 0, this.lit2val, 0, ltmp.length);
                Arrays.fill(this.lit2val, ltmp.length, var + 1, Integer.MAX_VALUE);
            }
            this.lit2pos[var] = pos;
            this.lit2val[var] = lvalue;
        }
        return SatSolver.makeLiteral(var, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void VariableBound(int index, boolean sign) throws ContradictionException {
        try {
            int lit;
            if (this.sat_trail_.get() < this.sat_.trailMarker()) {
                this.sat_.cancelUntil(this.sat_trail_.get());
                assert (this.sat_trail_.get() == this.sat_.trailMarker());
            }
            if (!this.sat_.propagateOneLiteral(lit = SatSolver.makeLiteral(index, sign))) {
                this.doReduce(SatSolver.negated(lit));
            } else {
                this.sat_trail_.set(this.sat_.trailMarker());
                for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
                    lit = this.sat_.touched_variables_.get(i);
                    this.doReduce(lit);
                }
            }
        }
        finally {
            this.sat_.touched_variables_.resetQuick();
        }
    }

    protected void doReduce(int lit) throws ContradictionException {
        int var = SatSolver.var(lit);
        long value = this.lit2val[var];
        IntVar ivar = ((IntVar[])this.vars)[this.lit2pos[var]];
        if (PropNogoods.iseq(value)) {
            if (SatSolver.sign(lit)) {
                ivar.instantiateTo(PropNogoods.ivalue(value), this);
            } else if (ivar.removeValue(PropNogoods.ivalue(value), this)) {
                this.fp.push(ivar);
            }
        } else if (SatSolver.sign(lit)) {
            if (ivar.updateUpperBound(PropNogoods.ivalue(value), this)) {
                this.fp.push(ivar);
            }
        } else if (ivar.updateLowerBound(PropNogoods.ivalue(value) + 1, this)) {
            this.fp.push(ivar);
        }
    }

    public boolean declareDomainNogood(IntVar var) {
        int size = var.getDomainSize();
        int[] lits = new int[size * 2];
        int a = var.getLB();
        int ub = var.getUB();
        int i = 0;
        while (a <= ub) {
            lits[i] = this.Literal(var, a, true);
            lits[i + size] = this.Literal(var, a, false);
            ++i;
            a = var.nextValue(a);
        }
        TIntArrayList clauses = new TIntArrayList();
        boolean add = false;
        for (int j = size; j < 2 * size - 1; ++j) {
            clauses.add(SatSolver.negated(lits[j]));
            clauses.add(lits[j + 1]);
            add |= this.sat_.addClause(clauses);
            clauses.clear();
        }
        for (int k = 0; k < size - 1; ++k) {
            clauses.add(lits[k]);
            clauses.add(SatSolver.negated(lits[size + k]));
            clauses.add(lits[size + k + 1]);
            add |= this.sat_.addClause(clauses);
            clauses.clear();
            clauses.add(SatSolver.negated(lits[k]));
            clauses.add(lits[size + k]);
            add |= this.sat_.addClause(clauses);
            clauses.clear();
            clauses.add(SatSolver.negated(lits[k]));
            clauses.add(SatSolver.negated(lits[size + k + 1]));
            add |= this.sat_.addClause(clauses);
            clauses.clear();
        }
        this.storeEarlyDeductions();
        return add;
    }

    public boolean addNogood(int p) {
        boolean result = this.sat_.addClause(p);
        this.storeEarlyDeductions();
        return result;
    }

    public boolean addNogood(TIntList lits) {
        boolean result = this.sat_.addClause(lits);
        this.storeEarlyDeductions();
        return result;
    }

    public void addLearnt(int ... lits) {
        this.sat_.learnClause(lits);
        this.forcePropagationOnBacktrack();
        if (this.sat_.nLearnt() > 1) {
            SatSolver.Clause last = this.sat_.learnts.get(this.sat_.learnts.size() - 1);
            this.test_eq.clear();
            for (int i = last.size() - 1; i >= 0; --i) {
                this.test_eq.set(last._g(i));
            }
            for (int c = this.sat_.learnts.size() - 2; c >= 0; --c) {
                int s = this.test_eq.cardinality();
                SatSolver.Clause prev = this.sat_.learnts.get(c);
                if (last.size() <= 1 || last.size() >= prev.size()) continue;
                for (int i = prev.size() - 1; i >= 0; --i) {
                    s -= this.test_eq.get(prev._g(i)) ? 1 : 0;
                }
                if (s != 0) continue;
                this.sat_.detachLearnt(c);
            }
        }
    }

    private void storeEarlyDeductions() {
        for (int i = 0; i < this.sat_.touched_variables_.size(); ++i) {
            int lit = this.sat_.touched_variables_.get(i);
            this.early_deductions_.add(lit);
        }
        this.sat_.touched_variables_.resetQuick();
    }

    protected void applyEarlyDeductions() throws ContradictionException {
        for (int i = 0; i < this.early_deductions_.size(); ++i) {
            int lit = this.early_deductions_.get(i);
            this.doReduce(lit);
        }
    }

    @Override
    public boolean why(RuleStore ruleStore, IntVar ivar, IEventType evt, int ivalue) {
        int i;
        ArrayList<SatSolver.Clause> mClauses;
        int l;
        int i2;
        if (this.inClauses == null) {
            this.fillInClauses();
        }
        boolean newrules = ruleStore.addPropagatorActivationRule(this);
        int var = this.vv2lit[ivar.getId()].get(ivalue);
        boolean new_value = true;
        if (!ivar.contains(ivalue)) {
            new_value = false;
        }
        int lit = SatSolver.makeLiteral(var, new_value);
        int neg = SatSolver.negated(lit);
        TIntList implies = this.sat_.implies_.get(lit);
        if (implies != null) {
            for (i2 = implies.size() - 1; i2 >= 0; --i2) {
                l = implies.get(i2);
                newrules |= this._why(l, ruleStore);
            }
        }
        if ((implies = (TIntList)this.sat_.implies_.get(neg)) != null) {
            for (i2 = implies.size() - 1; i2 >= 0; --i2) {
                l = implies.get(i2);
                newrules |= this._why(l, ruleStore);
            }
        }
        if ((mClauses = this.inClauses.get(lit)) != null) {
            for (i = mClauses.size() - 1; i >= 0; --i) {
                newrules |= this._why(mClauses.get(i), ruleStore);
            }
        }
        if ((mClauses = this.inClauses.get(neg)) != null) {
            for (i = mClauses.size() - 1; i >= 0; --i) {
                newrules |= this._why(mClauses.get(i), ruleStore);
            }
        }
        for (int k = this.sat_.nLearnt() - 1; k >= 0; --k) {
            newrules |= this._why(neg, lit, this.sat_.learnts.get(k), ruleStore);
        }
        return newrules;
    }

    private void fillInClauses() {
        this.inClauses = new TIntObjectHashMap();
        for (int k = this.sat_.nClauses() - 1; k >= 0; --k) {
            SatSolver.Clause cl = this.sat_.clauses.get(k);
            for (int d = cl.size() - 1; d >= 0; --d) {
                int l = cl._g(d);
                ArrayList<SatSolver.Clause> mcls = this.inClauses.get(l);
                if (mcls == null) {
                    mcls = new ArrayList();
                    this.inClauses.put(l, mcls);
                }
                mcls.add(cl);
            }
        }
    }

    private boolean _why(SatSolver.Clause cl, RuleStore ruleStore) {
        boolean newrules = false;
        if (this.litIsKnown(cl._g(0)) && this.litIsKnown(cl._g(1))) {
            for (int d = cl.size() - 1; d >= 0; --d) {
                newrules |= this._why(cl._g(d), ruleStore);
            }
        }
        return newrules;
    }

    private boolean _why(int neg, int lit, SatSolver.Clause cl, RuleStore ruleStore) {
        boolean newrules;
        block4: {
            block3: {
                newrules = false;
                if (cl._g(0) != neg && cl._g(0) != lit && cl._g(1) != neg && cl._g(1) != lit) break block3;
                for (int d = cl.size() - 1; d >= 0; --d) {
                    newrules |= this._why(cl._g(d), ruleStore);
                }
                break block4;
            }
            if (!this.litIsKnown(cl._g(0)) || !this.litIsKnown(cl._g(1))) break block4;
            int p = cl.pos(neg);
            int q = cl.pos(lit);
            if (p > -1 || q > -1) {
                for (int d = cl.size() - 1; d >= 0; --d) {
                    newrules |= this._why(cl._g(d), ruleStore);
                }
            }
        }
        return newrules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _why(int l, RuleStore ruleStore) {
        int _var = SatSolver.var(l);
        IntVar avar = ((IntVar[])this.vars)[this.lit2pos[_var]];
        long aval = this.lit2val[_var];
        if (PropNogoods.iseq(aval)) {
            if (!avar.contains(PropNogoods.ivalue(aval))) return ruleStore.addRemovalRule(avar, PropNogoods.ivalue(aval));
            if (!avar.isInstantiated()) return false;
            return ruleStore.addFullDomainRule(avar);
        }
        if (avar.getLB() > PropNogoods.ivalue(aval)) {
            return ruleStore.addLowerBoundRule(avar);
        }
        if (avar.getUB() > PropNogoods.ivalue(aval)) return false;
        return ruleStore.addUpperBoundRule(avar);
    }

    private boolean litIsKnown(int l) {
        int _var = SatSolver.var(l);
        IntVar avar = ((IntVar[])this.vars)[this.lit2pos[_var]];
        long aval = this.lit2val[_var];
        if (PropNogoods.iseq(aval)) {
            return !avar.contains(PropNogoods.ivalue(aval)) || avar.isInstantiated();
        }
        return avar.getLB() > PropNogoods.ivalue(aval) || avar.getUB() <= PropNogoods.ivalue(aval);
    }
}

