/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.flatten;

import org.chocosolver.memory.trailing.StoredBool;
import org.chocosolver.memory.trailing.trail.IStoredBoolTrail;

public class StoredBoolTrail
implements IStoredBoolTrail {
    private final double loadfactor;
    private StoredBool[] variableStack;
    private boolean[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;

    public StoredBoolTrail(int nUpdates, int nWorlds, double loadfactor) {
        this.variableStack = new StoredBool[nUpdates];
        this.valueStack = new boolean[nUpdates];
        this.stampStack = new int[nUpdates];
        this.worldStartLevels = new int[nWorlds];
        this.loadfactor = loadfactor;
    }

    @Override
    public void worldPush(int worldIndex) {
        this.worldStartLevels[worldIndex] = this.currentLevel;
        if (worldIndex == this.worldStartLevels.length - 1) {
            this.resizeWorldCapacity((int)((double)this.worldStartLevels.length * this.loadfactor));
        }
    }

    @Override
    public void worldPop(int worldIndex) {
        int wsl = this.worldStartLevels[worldIndex];
        while (this.currentLevel > wsl) {
            --this.currentLevel;
            StoredBool v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Deprecated
    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int worldIndex) {
        int startLevel = this.worldStartLevels[worldIndex];
        int prevWorld = worldIndex - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredBool var = this.variableStack[level];
            boolean val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.overrideTimeStamp(prevWorld);
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    @Override
    public void savePreviousState(StoredBool v, boolean oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.variableStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    @Override
    public void buildFakeHistory(StoredBool v, boolean initValue, int olderStamp) {
        this.savePreviousState(v, initValue, olderStamp - 1);
        while (this.currentLevel + olderStamp > this.variableStack.length) {
            this.resizeUpdateCapacity();
        }
        int s = this.currentLevel;
        for (int w = olderStamp; w > 1; --w) {
            int f = this.worldStartLevels[w];
            int i1 = f + w - 1;
            System.arraycopy(this.variableStack, f, this.variableStack, i1, s -= f);
            System.arraycopy(this.valueStack, f, this.valueStack, i1, s);
            System.arraycopy(this.stampStack, f, this.stampStack, i1, s);
            this.variableStack[i1 - 1] = v;
            this.valueStack[i1 - 1] = initValue;
            this.stampStack[i1 - 1] = w - 2;
            int n = w;
            this.worldStartLevels[n] = this.worldStartLevels[n] + (w - 1);
            ++this.currentLevel;
            s = f;
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
        StoredBool[] tmp1 = new StoredBool[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        boolean[] tmp2 = new boolean[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }

    private void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

