/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredLong;
import org.chocosolver.memory.trailing.trail.chunck.World;

public class LongWorld
implements World {
    private StoredLong[] variableStack;
    private long[] valueStack;
    private int[] stampStack;
    private int now = 0;
    private int defaultSize;
    private double loadfactor;

    public LongWorld(int defaultSize, double loadfactor) {
        this.loadfactor = loadfactor;
        this.defaultSize = defaultSize;
    }

    public void savePreviousState(StoredLong v, long oldValue, int oldStamp) {
        if (this.stampStack == null) {
            this.valueStack = new long[this.defaultSize];
            this.stampStack = new int[this.defaultSize];
            this.variableStack = new StoredLong[this.defaultSize];
        }
        this.valueStack[this.now] = oldValue;
        this.variableStack[this.now] = v;
        this.stampStack[this.now] = oldStamp;
        ++this.now;
        if (this.now == this.valueStack.length) {
            this.resizeUpdateCapacity();
        }
    }

    @Override
    public void revert() {
        for (int i = this.now - 1; i >= 0; --i) {
            this.variableStack[i]._set(this.valueStack[i], this.stampStack[i]);
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = (int)((double)this.variableStack.length * this.loadfactor);
        StoredLong[] tmp1 = new StoredLong[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        long[] tmp2 = new long[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
    }

    @Override
    public void clear() {
        this.now = 0;
    }

    @Override
    public int used() {
        return this.now;
    }

    @Override
    public int allocated() {
        return this.stampStack == null ? 0 : this.stampStack.length;
    }
}

