/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;

public abstract class IStateIntVector {
    public static final int MIN_CAPACITY = 8;
    protected int[] elementData;
    protected IStateInt size;
    protected final IEnvironment environment;

    public IStateIntVector(IEnvironment env, int initialSize, int initialValue) {
        int initialCapacity = 8;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.elementData[i] = initialValue;
        }
        this.size = env.makeInt(initialSize);
    }

    public IStateIntVector(IEnvironment env, int[] entries) {
        int initialCapacity = 8;
        int initialSize = entries.length;
        if (initialCapacity < initialSize) {
            initialCapacity = initialSize;
        }
        this.environment = env;
        this.elementData = new int[initialCapacity];
        System.arraycopy(entries, 0, this.elementData, 0, initialSize);
        this.size = env.makeInt(initialSize);
    }

    @Deprecated
    protected IStateIntVector(IEnvironment environment) {
        this.environment = environment;
    }

    protected boolean rangeCheck(int index) {
        return index < this.size.get() && index >= 0;
    }

    @Deprecated
    public int size() {
        return this.size.get();
    }

    @Deprecated
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public abstract void add(int var1);

    @Deprecated
    public boolean contains(int val) {
        int ssize = this.size.get();
        for (int i = 0; i < ssize; ++i) {
            if (val != this.elementData[i]) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public abstract void remove(int var1);

    @Deprecated
    public abstract void removeLast();

    @Deprecated
    public int get(int index) {
        if (this.rangeCheck(index)) {
            return this.elementData[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    public int quickGet(int index) {
        assert (this.rangeCheck(index));
        return this.elementData[index];
    }

    public abstract int set(int var1, int var2);

    public abstract int quickSet(int var1, int var2);

    @Deprecated
    public int[] deepCopy() {
        int[] ret = new int[this.size.get()];
        System.arraycopy(this.elementData, 0, ret, 0, this.size.get());
        return ret;
    }
}

