/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory;

import org.chocosolver.memory.ICondition;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.structure.BasicIndexedBipartiteSet;
import org.chocosolver.memory.structure.OneWordS32BitSet;
import org.chocosolver.memory.structure.OneWordS64BitSet;
import org.chocosolver.memory.structure.S64BitSet;

public abstract class AbstractEnvironment
implements IEnvironment {
    protected int currentWorld = 0;
    private static final int SIZE = 128;
    private ICondition condition = ICondition.FALSE;
    protected int timestamp = 0;
    private BasicIndexedBipartiteSet booleanSet;

    protected AbstractEnvironment() {
    }

    @Override
    public final int getWorldIndex() {
        return this.currentWorld;
    }

    @Override
    public final int getTimeStamp() {
        return this.timestamp;
    }

    @Override
    public IStateBitSet makeBitSet(int size) {
        if (size < 32) {
            return new OneWordS32BitSet(this, size);
        }
        if (size < 64) {
            return new OneWordS64BitSet(this, size);
        }
        return new S64BitSet(this, size);
    }

    @Override
    public void worldPopUntil(int w) {
        while (this.currentWorld > w) {
            this.worldPop();
        }
    }

    private void createSharedBipartiteSet(int size) {
        this.booleanSet = new BasicIndexedBipartiteSet(this, size);
    }

    @Override
    public final BasicIndexedBipartiteSet getSharedBipartiteSetForBooleanVars() {
        if (this.booleanSet == null) {
            this.createSharedBipartiteSet(128);
        }
        return this.booleanSet;
    }

    @Override
    public boolean fakeHistoryNeeded() {
        return this.condition.satisfied();
    }

    @Override
    public void buildFakeHistoryOn(ICondition condition) {
        this.condition = condition;
        this.condition.set(this);
    }
}

